/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class EnqueueTPUEmbeddingSparseTensorBatch
extends PrimitiveOp {
    public static <T extends Number, U extends Number, V extends Number> EnqueueTPUEmbeddingSparseTensorBatch create(Scope scope, Iterable<Operand<T>> sampleIndices, Iterable<Operand<U>> embeddingIndices, Iterable<Operand<V>> aggregationWeights, Operand<String> modeOverride, List<Long> tableIds, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("EnqueueTPUEmbeddingSparseTensorBatch", scope.makeOpName("EnqueueTPUEmbeddingSparseTensorBatch"));
        opBuilder.addInputList(Operands.asOutputs(sampleIndices));
        opBuilder.addInputList(Operands.asOutputs(embeddingIndices));
        opBuilder.addInputList(Operands.asOutputs(aggregationWeights));
        opBuilder.addInput(modeOverride.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        long[] tableIdsArray = new long[tableIds.size()];
        for (int i = 0; i < tableIdsArray.length; ++i) {
            tableIdsArray[i] = tableIds.get(i);
        }
        opBuilder.setAttr("table_ids", tableIdsArray);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.deviceOrdinal != null) {
                    opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
                }
                if (opts.combiners != null) {
                    String[] combinersArray = new String[opts.combiners.size()];
                    for (i = 0; i < combinersArray.length; ++i) {
                        combinersArray[i] = (String)opts.combiners.get(i);
                    }
                    opBuilder.setAttr("combiners", combinersArray);
                }
                if (opts.maxSequenceLengths == null) continue;
                long[] maxSequenceLengthsArray = new long[opts.maxSequenceLengths.size()];
                for (i = 0; i < maxSequenceLengthsArray.length; ++i) {
                    maxSequenceLengthsArray[i] = (Long)opts.maxSequenceLengths.get(i);
                }
                opBuilder.setAttr("max_sequence_lengths", maxSequenceLengthsArray);
            }
        }
        return new EnqueueTPUEmbeddingSparseTensorBatch(opBuilder.build());
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    public static Options combiners(List<String> combiners) {
        return new Options().combiners(combiners);
    }

    public static Options maxSequenceLengths(List<Long> maxSequenceLengths) {
        return new Options().maxSequenceLengths(maxSequenceLengths);
    }

    private EnqueueTPUEmbeddingSparseTensorBatch(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Long deviceOrdinal;
        private List<String> combiners;
        private List<Long> maxSequenceLengths;

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }

        public Options combiners(List<String> combiners) {
            this.combiners = combiners;
            return this;
        }

        public Options maxSequenceLengths(List<Long> maxSequenceLengths) {
            this.maxSequenceLengths = maxSequenceLengths;
            return this;
        }

        private Options() {
        }
    }
}

