/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BoostedTreesTrainingPredict
extends PrimitiveOp {
    private Output<Float> partialLogits;
    private Output<Integer> treeIds;
    private Output<Integer> nodeIds;

    public static BoostedTreesTrainingPredict create(Scope scope, Operand<?> treeEnsembleHandle, Operand<Integer> cachedTreeIds, Operand<Integer> cachedNodeIds, Iterable<Operand<Integer>> bucketizedFeatures, Long logitsDimension) {
        OperationBuilder opBuilder = scope.env().opBuilder("BoostedTreesTrainingPredict", scope.makeOpName("BoostedTreesTrainingPredict"));
        opBuilder.addInput(treeEnsembleHandle.asOutput());
        opBuilder.addInput(cachedTreeIds.asOutput());
        opBuilder.addInput(cachedNodeIds.asOutput());
        opBuilder.addInputList(Operands.asOutputs(bucketizedFeatures));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("logits_dimension", logitsDimension);
        return new BoostedTreesTrainingPredict(opBuilder.build());
    }

    public Output<Float> partialLogits() {
        return this.partialLogits;
    }

    public Output<Integer> treeIds() {
        return this.treeIds;
    }

    public Output<Integer> nodeIds() {
        return this.nodeIds;
    }

    private BoostedTreesTrainingPredict(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.partialLogits = operation.output(outputIdx++);
        this.treeIds = operation.output(outputIdx++);
        this.nodeIds = operation.output(outputIdx++);
    }
}

