/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.summary.AudioSummary;
import org.tensorflow.op.summary.HistogramSummary;
import org.tensorflow.op.summary.ImageSummary;
import org.tensorflow.op.summary.MergeSummary;
import org.tensorflow.op.summary.ScalarSummary;
import org.tensorflow.op.summary.TensorSummary;

public final class SummaryOps {
    private final Scope scope;

    SummaryOps(Scope scope) {
        this.scope = scope;
    }

    public <T> TensorSummary tensorSummary(Operand<String> tag, Operand<T> tensor, Operand<String> serializedSummaryMetadata) {
        return TensorSummary.create(this.scope, tag, tensor, serializedSummaryMetadata);
    }

    public <T extends Number> ImageSummary imageSummary(Operand<String> tag, Operand<T> tensor, ImageSummary.Options ... options) {
        return ImageSummary.create(this.scope, tag, tensor, options);
    }

    public <T extends Number> ScalarSummary scalarSummary(Operand<String> tags, Operand<T> values) {
        return ScalarSummary.create(this.scope, tags, values);
    }

    public MergeSummary mergeSummary(Iterable<Operand<String>> inputs) {
        return MergeSummary.create(this.scope, inputs);
    }

    public AudioSummary audioSummary(Operand<String> tag, Operand<Float> tensor, Operand<Float> sampleRate, AudioSummary.Options ... options) {
        return AudioSummary.create(this.scope, tag, tensor, sampleRate, options);
    }

    public <T extends Number> HistogramSummary histogramSummary(Operand<String> tag, Operand<T> values) {
        return HistogramSummary.create(this.scope, tag, values);
    }
}

