/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TemporaryVariable<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> ref;

    public static <T> TemporaryVariable<T> create(Scope scope, Shape shape, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("TemporaryVariable", scope.makeOpName("TemporaryVariable"));
        opBuilder.setAttr("shape", shape);
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.varName == null) continue;
                opBuilder.setAttr("var_name", opts.varName);
            }
        }
        return new TemporaryVariable<T>(opBuilder.build());
    }

    public static Options varName(String varName) {
        return new Options().varName(varName);
    }

    public Output<T> ref() {
        return this.ref;
    }

    @Override
    public Output<T> asOutput() {
        return this.ref;
    }

    private TemporaryVariable(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.ref = operation.output(outputIdx++);
    }

    public static class Options {
        private String varName;

        public Options varName(String varName) {
            this.varName = varName;
            return this;
        }

        private Options() {
        }
    }
}

