/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class AvgPool3DGrad<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> AvgPool3DGrad<T> create(Scope scope, Operand<Integer> origInputShape, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("AvgPool3DGrad", scope.makeOpName("AvgPool3DGrad"));
        opBuilder.addInput(origInputShape.asOutput());
        opBuilder.addInput(grad.asOutput());
        long[] ksizeArray = new long[ksize.size()];
        for (int i = 0; i < ksizeArray.length; ++i) {
            ksizeArray[i] = ksize.get(i);
        }
        opBuilder.setAttr("ksize", ksizeArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dataFormat == null) continue;
                opBuilder.setAttr("data_format", opts.dataFormat);
            }
        }
        return new AvgPool3DGrad<T>(opBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private AvgPool3DGrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String dataFormat;

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        private Options() {
        }
    }
}

