/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CollectiveReduce<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> data;

    public static <T extends Number> CollectiveReduce<T> create(Scope scope, Operand<T> input, Long groupSize, Long groupKey, Long instanceKey, String mergeOp, String finalOp, List<Long> subdivOffsets) {
        OperationBuilder opBuilder = scope.graph().opBuilder("CollectiveReduce", scope.makeOpName("CollectiveReduce"));
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("group_size", groupSize);
        opBuilder.setAttr("group_key", groupKey);
        opBuilder.setAttr("instance_key", instanceKey);
        opBuilder.setAttr("merge_op", mergeOp);
        opBuilder.setAttr("final_op", finalOp);
        long[] subdivOffsetsArray = new long[subdivOffsets.size()];
        for (int i = 0; i < subdivOffsetsArray.length; ++i) {
            subdivOffsetsArray[i] = subdivOffsets.get(i);
        }
        opBuilder.setAttr("subdiv_offsets", subdivOffsetsArray);
        return new CollectiveReduce<T>(opBuilder.build());
    }

    public Output<T> data() {
        return this.data;
    }

    @Override
    public Output<T> asOutput() {
        return this.data;
    }

    private CollectiveReduce(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.data = operation.output(outputIdx++);
    }
}

