/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ShuffleDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static ShuffleDataset create(Scope scope, Operand<?> inputDataset, Operand<Long> bufferSize, Operand<Long> seed, Operand<Long> seed2, List<Class<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("ShuffleDataset", scope.makeOpName("ShuffleDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(bufferSize.asOutput());
        opBuilder.addInput(seed.asOutput());
        opBuilder.addInput(seed2.asOutput());
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.reshuffleEachIteration == null) continue;
                opBuilder.setAttr("reshuffle_each_iteration", opts.reshuffleEachIteration);
            }
        }
        return new ShuffleDataset(opBuilder.build());
    }

    public static Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
        return new Options().reshuffleEachIteration(reshuffleEachIteration);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private ShuffleDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean reshuffleEachIteration;

        public Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
            this.reshuffleEachIteration = reshuffleEachIteration;
            return this;
        }

        private Options() {
        }
    }
}

