/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.services;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class BotLogger {
    private static final Object lockToWrite;
    private static volatile PrintWriter logginFile;
    private static volatile String currentFileName;
    private static final String pathToLogs = "./";
    private static final Logger logger;
    private static volatile LocalDateTime lastFileDate;
    private static LoggerThread loggerThread;
    private static final ConcurrentLinkedQueue<String> logsToFile;

    public static void setLevel(Level level) {
        logger.setLevel(level);
    }

    public static void log(@NotNull Level level, String tag, String msg) {
        logger.log(level, String.format("[%s] %s", tag, msg));
        BotLogger.logToFile(level, tag, msg);
    }

    public static void severe(String tag, String msg) {
        logger.severe(String.format("[%s] %s", tag, msg));
        BotLogger.logToFile(Level.SEVERE, tag, msg);
    }

    public static void warn(String tag, String msg) {
        BotLogger.warning(tag, msg);
    }

    public static void debug(String tag, String msg) {
        BotLogger.fine(tag, msg);
    }

    public static void error(String tag, String msg) {
        BotLogger.severe(tag, msg);
    }

    public static void trace(String tag, String msg) {
        BotLogger.finer(tag, msg);
    }

    public static void warning(String tag, String msg) {
        logger.warning(String.format("[%s] %s", tag, msg));
        BotLogger.logToFile(Level.WARNING, tag, msg);
    }

    public static void info(String tag, String msg) {
        logger.info(String.format("[%s] %s", tag, msg));
        BotLogger.logToFile(Level.INFO, tag, msg);
    }

    public static void config(String tag, String msg) {
        logger.config(String.format("[%s] %s", tag, msg));
        BotLogger.logToFile(Level.CONFIG, tag, msg);
    }

    public static void fine(String tag, String msg) {
        logger.fine(String.format("[%s] %s", tag, msg));
        BotLogger.logToFile(Level.FINE, tag, msg);
    }

    public static void finer(String tag, String msg) {
        logger.finer(String.format("[%s] %s", tag, msg));
        BotLogger.logToFile(Level.FINER, tag, msg);
    }

    public static void finest(String tag, String msg) {
        logger.finest(String.format("[%s] %s", tag, msg));
        BotLogger.logToFile(Level.FINEST, tag, msg);
    }

    public static void log(@NotNull Level level, @NotNull String tag, @NotNull Throwable throwable) {
        logger.log(level, String.format("[%s] Exception", tag), throwable);
        BotLogger.logToFile(level, tag, throwable);
    }

    public static void log(@NotNull Level level, @NotNull String tag, @NotNull String msg, @NotNull Throwable thrown) {
        logger.log(level, msg, thrown);
        BotLogger.logToFile(level, msg, thrown);
    }

    public static void severe(@NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.logToFile(Level.SEVERE, tag, throwable);
    }

    public static void warning(@NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.logToFile(Level.WARNING, tag, throwable);
    }

    public static void info(@NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.logToFile(Level.INFO, tag, throwable);
    }

    public static void config(@NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.logToFile(Level.CONFIG, tag, throwable);
    }

    public static void fine(@NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.logToFile(Level.FINE, tag, throwable);
    }

    public static void finer(@NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.logToFile(Level.FINER, tag, throwable);
    }

    public static void finest(@NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.logToFile(Level.FINEST, tag, throwable);
    }

    public static void warn(@NotNull String tag, Throwable throwable) {
        BotLogger.warning(tag, throwable);
    }

    public static void debug(@NotNull String tag, Throwable throwable) {
        BotLogger.fine(tag, throwable);
    }

    public static void error(@NotNull String tag, Throwable throwable) {
        BotLogger.severe(tag, throwable);
    }

    public static void trace(@NotNull String tag, Throwable throwable) {
        BotLogger.finer(tag, throwable);
    }

    public static void severe(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.SEVERE, tag, msg, throwable);
    }

    public static void warning(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.WARNING, tag, msg, throwable);
    }

    public static void info(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.INFO, tag, msg, throwable);
    }

    public static void config(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.CONFIG, tag, msg, throwable);
    }

    public static void fine(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.FINE, tag, msg, throwable);
    }

    public static void finer(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.FINER, tag, msg, throwable);
    }

    public static void finest(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.FINEST, msg, throwable);
    }

    public static void warn(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.WARNING, tag, msg, throwable);
    }

    public static void debug(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.FINE, tag, msg, throwable);
    }

    public static void error(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.SEVERE, tag, msg, throwable);
    }

    public static void trace(@NotNull String msg, @NotNull String tag, @NotNull Throwable throwable) {
        BotLogger.log(Level.FINER, tag, msg, throwable);
    }

    private static boolean isCurrentDate(LocalDateTime dateTime) {
        return dateTime.toLocalDate().isEqual(lastFileDate.toLocalDate());
    }

    private static String dateFormatterForFileName(@NotNull LocalDateTime dateTime) {
        String dateString = "";
        dateString = dateString + dateTime.getDayOfMonth();
        dateString = dateString + dateTime.getMonthValue();
        dateString = dateString + dateTime.getYear();
        return dateString;
    }

    private static String dateFormatterForLogs(@NotNull LocalDateTime dateTime) {
        String dateString = "[";
        dateString = dateString + dateTime.getDayOfMonth() + "_";
        dateString = dateString + dateTime.getMonthValue() + "_";
        dateString = dateString + dateTime.getYear() + "_";
        dateString = dateString + dateTime.getHour() + ":";
        dateString = dateString + dateTime.getMinute() + ":";
        dateString = dateString + dateTime.getSecond();
        dateString = dateString + "] ";
        return dateString;
    }

    private static void updateAndCreateFile(LocalDateTime dateTime) {
        block5: {
            if (!BotLogger.isCurrentDate(dateTime)) {
                lastFileDate = LocalDateTime.now();
                currentFileName = pathToLogs + BotLogger.dateFormatterForFileName(lastFileDate) + ".log";
                try {
                    logginFile.flush();
                    logginFile.close();
                    File file = new File(currentFileName);
                    if (file.exists()) {
                        logginFile = new PrintWriter(new BufferedWriter(new FileWriter(currentFileName, true)));
                        break block5;
                    }
                    boolean created = file.createNewFile();
                    if (created) {
                        logginFile = new PrintWriter(new BufferedWriter(new FileWriter(currentFileName, true)));
                        break block5;
                    }
                    throw new NullPointerException("Error updating log file");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logToFile(@NotNull Level level, @NotNull String tag, @NotNull Throwable throwable) {
        if (BotLogger.isLoggable(level)) {
            Object object = lockToWrite;
            synchronized (object) {
                LocalDateTime currentDate = LocalDateTime.now();
                String dateForLog = BotLogger.dateFormatterForLogs(currentDate);
                BotLogger.updateAndCreateFile(currentDate);
                BotLogger.logThrowableToFile(level, tag, throwable, dateForLog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logToFile(@NotNull Level level, @NotNull String tag, @NotNull String msg) {
        if (BotLogger.isLoggable(level)) {
            Object object = lockToWrite;
            synchronized (object) {
                LocalDateTime currentDate = LocalDateTime.now();
                BotLogger.updateAndCreateFile(currentDate);
                String dateForLog = BotLogger.dateFormatterForLogs(currentDate);
                BotLogger.logMsgToFile(level, tag, msg, dateForLog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logToFile(Level level, @NotNull String tag, @NotNull String msg, @NotNull Throwable throwable) {
        if (BotLogger.isLoggable(level)) {
            Object object = lockToWrite;
            synchronized (object) {
                LocalDateTime currentDate = LocalDateTime.now();
                BotLogger.updateAndCreateFile(currentDate);
                String dateForLog = BotLogger.dateFormatterForLogs(currentDate);
                BotLogger.logMsgToFile(level, tag, msg, dateForLog);
                BotLogger.logThrowableToFile(level, tag, throwable, dateForLog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logMsgToFile(@NotNull Level level, @NotNull String tag, @NotNull String msg, @NotNull String dateForLog) {
        String logMessage = String.format("%s{%s} %s - %s", dateForLog, level.toString(), tag, msg);
        logsToFile.add(logMessage);
        ConcurrentLinkedQueue<String> concurrentLinkedQueue = logsToFile;
        synchronized (concurrentLinkedQueue) {
            logsToFile.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logThrowableToFile(@NotNull Level level, @NotNull String tag, @NotNull Throwable throwable, @NotNull String dateForLog) {
        String throwableLog = String.format("%s{%s} %s - %s", dateForLog, level.toString(), tag, throwable.toString());
        for (StackTraceElement element : throwable.getStackTrace()) {
            throwableLog = throwableLog + "\tat " + element + "\n";
        }
        logsToFile.add(throwableLog);
        ConcurrentLinkedQueue<String> concurrentLinkedQueue = logsToFile;
        synchronized (concurrentLinkedQueue) {
            logsToFile.notifyAll();
        }
    }

    private static boolean isLoggable(Level level) {
        return logger.isLoggable(level);
    }

    static {
        block5: {
            lockToWrite = new Object();
            logger = Logger.getLogger("Telegram Bot");
            loggerThread = new LoggerThread();
            logsToFile = new ConcurrentLinkedQueue();
            logger.setLevel(Level.INFO);
            loggerThread.start();
            lastFileDate = LocalDateTime.now();
            if (currentFileName == null || currentFileName.compareTo("") == 0) {
                currentFileName = pathToLogs + BotLogger.dateFormatterForFileName(lastFileDate) + ".log";
                try {
                    File file = new File(currentFileName);
                    if (file.exists()) {
                        logginFile = new PrintWriter(new BufferedWriter(new FileWriter(currentFileName, true)));
                        break block5;
                    }
                    boolean created = file.createNewFile();
                    if (created) {
                        logginFile = new PrintWriter(new BufferedWriter(new FileWriter(currentFileName, true)));
                        break block5;
                    }
                    throw new NullPointerException("File for logging error");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static class LoggerThread
    extends Thread {
        private LoggerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ConcurrentLinkedQueue stringsToLog = new ConcurrentLinkedQueue();
                ConcurrentLinkedQueue concurrentLinkedQueue = logsToFile;
                synchronized (concurrentLinkedQueue) {
                    if (logsToFile.isEmpty()) {
                        try {
                            logsToFile.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (logsToFile.isEmpty()) {
                            continue;
                        }
                    }
                    stringsToLog.addAll(logsToFile);
                    logsToFile.clear();
                }
                stringsToLog.stream().forEach(logginFile::println);
                logginFile.flush();
            }
        }
    }
}

