/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.telegram.api.channel.filters.TLChannelMessagesFilterEmpty;
import org.telegram.api.chat.TLAbsChat;
import org.telegram.api.engine.RpcException;
import org.telegram.api.functions.updates.TLRequestUpdatesGetChannelDifference;
import org.telegram.api.functions.updates.TLRequestUpdatesGetDifference;
import org.telegram.api.input.chat.TLInputChannel;
import org.telegram.api.message.TLAbsMessage;
import org.telegram.api.update.TLAbsUpdate;
import org.telegram.api.updates.TLUpdatesState;
import org.telegram.api.updates.channel.differences.TLAbsUpdatesChannelDifferences;
import org.telegram.api.updates.channel.differences.TLUpdatesChannelDifferences;
import org.telegram.api.updates.channel.differences.TLUpdatesChannelDifferencesEmpty;
import org.telegram.api.updates.channel.differences.TLUpdatesChannelDifferencesTooLong;
import org.telegram.api.updates.difference.TLAbsDifference;
import org.telegram.api.updates.difference.TLDifference;
import org.telegram.api.updates.difference.TLDifferenceSlice;
import org.telegram.api.updates.difference.TLDifferenceTooLong;
import org.telegram.api.user.TLAbsUser;
import org.telegram.bot.handlers.interfaces.IDifferencesHandler;
import org.telegram.bot.handlers.interfaces.IUpdatesHandler;
import org.telegram.bot.kernel.IKernelComm;
import org.telegram.bot.kernel.differenceparameters.IDifferenceParametersService;
import org.telegram.bot.services.BotLogger;

public class DifferencesHandler
implements IDifferencesHandler {
    private static final String LOGTAG = "DIFFERENCESHANDLER";
    private static final Object differencesLock = new Object();
    private final IDifferenceParametersService differenceParametersService;
    private final IKernelComm kernelComm;
    private final IUpdatesHandler updatesHandlerBase;

    public DifferencesHandler(IKernelComm kernelComm, IDifferenceParametersService differenceParametersService, IUpdatesHandler updatesHandlerBase) {
        this.differenceParametersService = differenceParametersService;
        this.kernelComm = kernelComm;
        this.updatesHandlerBase = updatesHandlerBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getDifferences() {
        Object object = differencesLock;
        synchronized (object) {
            boolean canGetDifferences = this.canGetDifferences();
            if (canGetDifferences) {
                BotLogger.info(LOGTAG, "Getting differences");
                TLRequestUpdatesGetDifference requestUpdatesGetDifference = new TLRequestUpdatesGetDifference();
                requestUpdatesGetDifference.setQts(0);
                TLAbsDifference absDifference = null;
                do {
                    requestUpdatesGetDifference.setDate(this.differenceParametersService.getDate(0));
                    requestUpdatesGetDifference.setPts(this.differenceParametersService.getPts(0));
                    try {
                        absDifference = this.kernelComm.doRpcCallSync(requestUpdatesGetDifference);
                        if (absDifference != null) {
                            this.onTLAbsDifferences(absDifference);
                        }
                    }
                    catch (ExecutionException | RpcException e) {
                        BotLogger.error(LOGTAG, e);
                    }
                    try {
                        DifferencesHandler e = this;
                        synchronized (e) {
                            if (absDifference instanceof TLDifferenceSlice) {
                                this.wait(100L);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        BotLogger.error(LOGTAG, e);
                    }
                } while (absDifference instanceof TLDifferenceSlice);
                BotLogger.info(LOGTAG, "Getting differences finished");
            }
        }
    }

    @Override
    public void updateStateModification(@NotNull TLUpdatesState state, boolean isGettingDifferent) {
        if (!isGettingDifferent && this.differenceParametersService.getPts(0) != 0 && this.differenceParametersService.getSeq(0) != 0) {
            this.getDifferences();
        } else {
            this.differenceParametersService.setNewUpdateParams(0, state.getPts(), state.getSeq(), state.getDate());
        }
    }

    @Override
    public void getChannelDifferences(int chatId, long accessHash) {
        if (accessHash == 0L) {
            this.getDifferences();
        } else {
            this.getChannelDifferencesInternal(chatId, accessHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getChannelDifferencesInternal(int chatId, long accessHash) {
        Object object = differencesLock;
        synchronized (object) {
            BotLogger.info(LOGTAG, "Getting differences");
            TLRequestUpdatesGetChannelDifference requestGetChannelDifference = new TLRequestUpdatesGetChannelDifference();
            requestGetChannelDifference.setFilter(new TLChannelMessagesFilterEmpty());
            TLInputChannel inputChannel = new TLInputChannel();
            inputChannel.setChannelId(chatId);
            inputChannel.setAccessHash(accessHash);
            requestGetChannelDifference.setChannel(inputChannel);
            TLAbsUpdatesChannelDifferences absDifference = null;
            do {
                int pts;
                requestGetChannelDifference.setPts((pts = this.differenceParametersService.getPts(chatId)) == 0 ? 1 : pts);
                requestGetChannelDifference.setLimit(100);
                try {
                    absDifference = this.kernelComm.doRpcCallSync(requestGetChannelDifference);
                    if (absDifference != null && !(absDifference instanceof TLUpdatesChannelDifferencesEmpty)) {
                        this.onTLAbsUpdatesChannelDifferences(chatId, absDifference);
                    }
                }
                catch (ExecutionException | RpcException e) {
                    BotLogger.error(LOGTAG, e);
                }
                try {
                    DifferencesHandler e = this;
                    synchronized (e) {
                        if (absDifference instanceof TLUpdatesChannelDifferencesTooLong) {
                            this.wait(100L);
                        }
                    }
                }
                catch (InterruptedException e) {
                    BotLogger.error(LOGTAG, e);
                }
            } while (absDifference instanceof TLUpdatesChannelDifferencesTooLong);
            BotLogger.info(LOGTAG, "Getting differences finished");
        }
    }

    @Override
    public void updateChannelStateModification(int chatId, @Nullable Long accessHash, int pts, boolean isGettingDifferent) {
        if (!isGettingDifferent && this.differenceParametersService.getPts(chatId) != 0 && this.differenceParametersService.getSeq(chatId) != 0 && accessHash != null) {
            this.getChannelDifferences(chatId, accessHash);
        } else {
            this.differenceParametersService.setNewUpdateParams(chatId, pts, null, 0);
        }
    }

    private void onTLAbsDifferences(@NotNull TLAbsDifference absDifference) {
        BotLogger.info(LOGTAG, "Received differences");
        if (absDifference instanceof TLDifferenceSlice) {
            TLUpdatesState updatesState = ((TLDifferenceSlice)absDifference).getIntermediateState();
            this.handleDifferences(absDifference, updatesState);
        } else if (absDifference instanceof TLDifference) {
            TLUpdatesState updatesState = ((TLDifference)absDifference).getState();
            this.handleDifferences(absDifference, updatesState);
        } else if (absDifference instanceof TLDifferenceTooLong) {
            TLUpdatesState state = new TLUpdatesState();
            state.setPts(((TLDifferenceTooLong)absDifference).getPts());
            this.updateStateModification(state, true);
        }
    }

    private void onTLAbsUpdatesChannelDifferences(int chatId, TLAbsUpdatesChannelDifferences absDifference) {
        if (absDifference instanceof TLUpdatesChannelDifferences) {
            TLUpdatesChannelDifferences differences = (TLUpdatesChannelDifferences)absDifference;
            this.handleChannelDifferences(chatId, differences.getPts(), differences.getUsers(), differences.getNewMessages(), differences.getOtherUpdates(), differences.getChats());
        } else if (absDifference instanceof TLUpdatesChannelDifferencesTooLong) {
            TLUpdatesChannelDifferencesTooLong differences = (TLUpdatesChannelDifferencesTooLong)absDifference;
            this.handleChannelDifferences(chatId, differences.getPts(), differences.getUsers(), differences.getMessages(), new ArrayList<TLAbsUpdate>(), differences.getChats());
        }
    }

    private void handleChannelDifferences(int chatId, int pts, List<TLAbsUser> users, List<TLAbsMessage> messages, List<TLAbsUpdate> updates, List<TLAbsChat> chats) {
        BotLogger.info(LOGTAG, "Handling channel differences");
        this.updatesHandlerBase.onTLChannelDifferences(users, messages, updates, chats);
        this.updateChannelStateModification(chatId, null, pts, true);
    }

    private void handleDifferences(@NotNull TLAbsDifference absDifference, @NotNull TLUpdatesState updatesState) {
        BotLogger.info(LOGTAG, "Handling differences");
        this.updatesHandlerBase.onTLAbsDifference(absDifference);
        this.updateStateModification(updatesState, true);
    }

    @Contract(pure=true)
    private boolean canGetDifferences() {
        return this.differenceParametersService.getPts(0) != 0 && this.differenceParametersService.getSeq(0) != 0;
    }
}

