/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.paymentapi.payments;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.TLDataJSON;
import org.telegram.api.paymentapi.TLInvoice;
import org.telegram.api.paymentapi.TLPaymentRequestedInfo;
import org.telegram.api.paymentapi.savedcredentails.TLAbsPaymentSavedCredentials;
import org.telegram.api.user.TLAbsUser;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLObject;
import org.telegram.tl.TLVector;

public class TLPaymentsPaymentForm
extends TLObject {
    public static final int CLASS_ID = 1062645411;
    private static final int FLAG_SAVED_INFO = 1;
    private static final int FLAG_SAVED_CREDENTIALS = 2;
    private static final int FLAG_CAN_SAVE_CREDENTIALS = 4;
    private static final int FLAG_PASSWORD_MISSING = 8;
    private static final int FLAG_NATIVE = 16;
    private int flags;
    private int botId;
    private TLInvoice invoice;
    private int providerId;
    private String url;
    private String nativeProvider;
    private TLDataJSON nativeParams;
    private TLPaymentRequestedInfo savedInfo;
    private TLAbsPaymentSavedCredentials savedCredentials;
    private TLVector<TLAbsUser> users;

    @Override
    public int getClassId() {
        return 1062645411;
    }

    public int getBotId() {
        return this.botId;
    }

    public TLInvoice getInvoice() {
        return this.invoice;
    }

    public int getProviderId() {
        return this.providerId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getNativeProvider() {
        return this.nativeProvider;
    }

    public TLDataJSON getNativeParams() {
        return this.nativeParams;
    }

    public TLPaymentRequestedInfo getSavedInfo() {
        return this.savedInfo;
    }

    public TLAbsPaymentSavedCredentials getSavedCredentials() {
        return this.savedCredentials;
    }

    public TLVector<TLAbsUser> getUsers() {
        return this.users;
    }

    public boolean canSaveCredentials() {
        return (this.flags & 4) != 0;
    }

    public boolean isPasswordMissing() {
        return (this.flags & 8) != 0;
    }

    public boolean isNative() {
        return (this.flags & 0x10) != 0;
    }

    public boolean hasSavedInfo() {
        return (this.flags & 1) != 0;
    }

    public boolean hasSavedCredentials() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeInt(this.botId, stream);
        StreamingUtils.writeTLObject(this.invoice, stream);
        StreamingUtils.writeInt(this.providerId, stream);
        StreamingUtils.writeTLString(this.url, stream);
        if (this.isNative()) {
            StreamingUtils.writeTLString(this.nativeProvider, stream);
            StreamingUtils.writeTLObject(this.nativeParams, stream);
        }
        if (this.hasSavedInfo()) {
            StreamingUtils.writeTLObject(this.savedInfo, stream);
        }
        if (this.hasSavedCredentials()) {
            StreamingUtils.writeTLObject(this.savedCredentials, stream);
        }
        StreamingUtils.writeTLVector(this.users, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.botId = StreamingUtils.readInt(stream);
        this.invoice = StreamingUtils.readTLObject(stream, context, TLInvoice.class);
        this.providerId = StreamingUtils.readInt(stream);
        this.url = StreamingUtils.readTLString(stream);
        if (this.isNative()) {
            this.nativeProvider = StreamingUtils.readTLString(stream);
            this.nativeParams = StreamingUtils.readTLObject(stream, context, TLDataJSON.class);
        }
        if (this.hasSavedInfo()) {
            this.savedInfo = StreamingUtils.readTLObject(stream, context, TLPaymentRequestedInfo.class);
        }
        if (this.hasSavedCredentials()) {
            this.savedCredentials = StreamingUtils.readTLObject(stream, context, TLAbsPaymentSavedCredentials.class);
        }
        this.users = StreamingUtils.readTLVector(stream, context, TLAbsUser.class);
    }

    @Override
    public String toString() {
        return "payments.paymentForm#3f56aea3";
    }
}

