/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.metaprogramming.impl.CompositeMethodGenerator;
import org.teavm.metaprogramming.impl.ValueImpl;
import org.teavm.metaprogramming.impl.VariableContext;
import org.teavm.model.AccessLevel;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.FieldHolder;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;

public class ProxyVariableContext
extends VariableContext {
    private Map<ValueImpl<?>, Variable> cache = new HashMap();
    private BasicBlock startBlock;
    private ClassHolder proxyClass;
    private int suffixGenerator;
    private Map<Variable, CapturedValue> capturedValueMap = new HashMap<Variable, CapturedValue>();
    private List<CapturedValue> capturedValues = new ArrayList<CapturedValue>();

    public ProxyVariableContext(VariableContext parent, ClassHolder proxyClass) {
        super(parent);
        this.proxyClass = proxyClass;
    }

    public void init(BasicBlock startBlock) {
        this.startBlock = startBlock;
        this.cache.clear();
    }

    @Override
    public Variable emitVariable(ValueImpl<?> value, CallLocation location) {
        return this.cache.computeIfAbsent(value, v -> this.createVariable((ValueImpl<?>)v, location));
    }

    private Variable createVariable(ValueImpl<?> value, CallLocation location) {
        if (value.context == this) {
            return value.innerValue;
        }
        Variable outerVar = this.getParent().emitVariable(value, location);
        CapturedValue capturedValue = this.capturedValueMap.computeIfAbsent(outerVar, v -> {
            FieldHolder field = new FieldHolder("proxyCapture" + this.suffixGenerator++);
            field.setLevel(AccessLevel.PUBLIC);
            field.setType(value.type);
            this.proxyClass.addField(field);
            CapturedValue result = new CapturedValue(field, (Variable)v);
            this.capturedValues.add(result);
            return result;
        });
        Program program = this.startBlock.getProgram();
        Variable var = program.createVariable();
        GetFieldInstruction insn = new GetFieldInstruction();
        insn.setInstance(program.variableAt(0));
        insn.setField(capturedValue.field.getReference());
        insn.setFieldType(capturedValue.field.getType());
        insn.setReceiver(var);
        this.startBlock.add((Instruction)insn);
        return var;
    }

    public Variable createInstance(CompositeMethodGenerator generator) {
        ValueType[] signature = new ValueType[this.capturedValues.size() + 1];
        for (int i = 0; i < this.capturedValues.size(); ++i) {
            signature[i] = this.capturedValues.get((int)i).field.getType();
        }
        signature[this.capturedValues.size()] = ValueType.VOID;
        MethodHolder ctor = new MethodHolder("<init>", signature);
        ctor.setLevel(AccessLevel.PUBLIC);
        Program ctorProgram = new Program();
        ctor.setProgram(ctorProgram);
        BasicBlock ctorBlock = ctorProgram.createBasicBlock();
        InvokeInstruction invokeSuper = new InvokeInstruction();
        invokeSuper.setInstance(ctorProgram.createVariable());
        invokeSuper.setMethod(new MethodReference(this.proxyClass.getParent(), "<init>", new ValueType[]{ValueType.VOID}));
        invokeSuper.setType(InvocationType.SPECIAL);
        ctorBlock.add((Instruction)invokeSuper);
        for (int i = 0; i < this.capturedValues.size(); ++i) {
            PutFieldInstruction putInsn = new PutFieldInstruction();
            putInsn.setField(this.capturedValues.get((int)i).field.getReference());
            putInsn.setFieldType(this.capturedValues.get((int)i).field.getType());
            putInsn.setValue(ctorProgram.createVariable());
            putInsn.setInstance(ctorProgram.variableAt(0));
            ctorBlock.add((Instruction)putInsn);
        }
        ExitInstruction exit = new ExitInstruction();
        ctorBlock.add((Instruction)exit);
        this.proxyClass.addMethod(ctor);
        ConstructInstruction constructInsn = new ConstructInstruction();
        constructInsn.setReceiver(generator.program.createVariable());
        constructInsn.setType(this.proxyClass.getName());
        generator.add((Instruction)constructInsn);
        InvokeInstruction initInsn = new InvokeInstruction();
        initInsn.setInstance(constructInsn.getReceiver());
        initInsn.setMethod(ctor.getReference());
        initInsn.setType(InvocationType.SPECIAL);
        for (int i = 0; i < this.capturedValues.size(); ++i) {
            initInsn.getArguments().add(this.capturedValues.get((int)i).value);
        }
        generator.add((Instruction)initInsn);
        return constructInsn.getReceiver();
    }

    class CapturedValue {
        FieldHolder field;
        Variable value;

        CapturedValue(FieldHolder field, Variable value) {
            this.field = field;
            this.value = value;
        }
    }
}

