/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming;

import java.util.Objects;
import org.teavm.metaprogramming.reflect.ReflectMethod;

public class SourceLocation {
    private ReflectMethod method;
    private String fileName;
    private int lineNumber;

    public SourceLocation(ReflectMethod method, String fileName, int lineNumber) {
        this.method = method;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public SourceLocation(ReflectMethod method) {
        this(method, null, -1);
    }

    public ReflectMethod getMethod() {
        return this.method;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SourceLocation)) {
            return false;
        }
        SourceLocation other = (SourceLocation)obj;
        return this.method == other.method && Objects.equals(this.fileName, other.fileName) && this.lineNumber == other.lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.method, this.fileName, this.lineNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.getName());
        sb.append((String)(this.lineNumber > 0 ? this.fileName + ":" + this.lineNumber : this.fileName));
        return sb.toString();
    }
}

