/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.devserver;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class ProxyWsClient {
    private Session session;
    private ProxyWsClient target;
    private boolean closed;
    private List<Consumer<ProxyWsClient>> pendingMessages = new ArrayList<Consumer<ProxyWsClient>>();

    public void setTarget(ProxyWsClient target) {
        if (this.target != null) {
            throw new IllegalStateException();
        }
        this.target = target;
        this.flush();
        target.flush();
    }

    @OnWebSocketConnect
    public void connect(Session session) {
        session.getPolicy().setMaxBinaryMessageSize(100000000);
        session.getPolicy().setMaxTextMessageSize(100000000);
        this.session = session;
        this.flush();
        if (this.target != null) {
            this.target.flush();
        }
    }

    @OnWebSocketClose
    public void close(int code, String reason) {
        this.closed = true;
        if (!this.target.closed) {
            this.target.closed = true;
            this.session.close(code, reason);
        }
    }

    @OnWebSocketMessage
    public void onMessage(byte[] buf, int offset, int length) {
        this.send(t -> t.session.getRemote().sendBytesByFuture(ByteBuffer.wrap(buf, offset, length)));
    }

    @OnWebSocketMessage
    public void onMessage(String text) {
        this.send(t -> t.session.getRemote().sendStringByFuture(text));
    }

    private void send(Consumer<ProxyWsClient> message) {
        if (this.target == null || this.target.session == null || !this.target.session.isOpen()) {
            if (this.pendingMessages != null) {
                this.pendingMessages.add(message);
            }
        } else {
            message.accept(this.target);
        }
    }

    private void flush() {
        if (this.pendingMessages == null || this.target == null || this.target.session == null || !this.target.session.isOpen()) {
            return;
        }
        for (Consumer<ProxyWsClient> message : this.pendingMessages) {
            message.accept(this.target);
        }
        this.pendingMessages = null;
    }
}

