/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import org.teavm.apachecommons.cli.CommandLine;
import org.teavm.apachecommons.cli.DefaultParser;
import org.teavm.apachecommons.cli.HelpFormatter;
import org.teavm.apachecommons.cli.Option;
import org.teavm.apachecommons.cli.Options;
import org.teavm.apachecommons.cli.ParseException;
import org.teavm.backend.javascript.JSModuleType;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.callgraph.CallGraph;
import org.teavm.cli.AccumulatingTeaVMToolLog;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.tooling.ConsoleTeaVMToolLog;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.util.FileSystemWatcher;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;

public final class TeaVMRunner {
    private static Options options = new Options();
    private TeaVMTool tool = new TeaVMTool();
    private AccumulatingTeaVMToolLog log = new AccumulatingTeaVMToolLog((TeaVMToolLog)new ConsoleTeaVMToolLog(false));
    private CommandLine commandLine;
    private long startTime;
    private long phaseStartTime;
    private String[] classPath;
    private boolean interactive;

    private static void setupOptions() {
        options.addOption(Option.builder((String)"t").argName("target").hasArg().desc("target type (javascript/js, webassembly/wasm, webassembly-wasi/wasm-wasi/wasi, C)").build());
        options.addOption(Option.builder((String)"d").argName("directory").hasArg().desc("a directory where to put generated files (current directory by default)").longOpt("targetdir").build());
        options.addOption(Option.builder((String)"f").argName("file").hasArg().desc("a file where to put decompiled classes (classes.js by default)").longOpt("targetfile").build());
        options.addOption(Option.builder((String)"m").desc("causes TeaVM to generate minimized JavaScript file").longOpt("minify").build());
        options.addOption(Option.builder().longOpt("strict").desc("causes TeaVM to produce code that is as close to Java semantics as possible (in cost of performance)").build());
        options.addOption(Option.builder((String)"O").desc("optimization level (1-3)").hasArg().argName("number").build());
        options.addOption(Option.builder((String)"g").desc("Generate debug information").longOpt("debug").build());
        options.addOption(Option.builder((String)"G").desc("Generate source maps").longOpt("sourcemaps").build());
        options.addOption(Option.builder((String)"i").desc("Incremental build").longOpt("incremental").build());
        options.addOption(Option.builder((String)"c").argName("directory").hasArg().desc("Incremental build cache directory").longOpt("cachedir").build());
        options.addOption(Option.builder((String)"w").desc("Wait for command after compilation, in order to enable hot recompilation").longOpt("wait").build());
        options.addOption(Option.builder((String)"p").argName("classpath").hasArgs().desc("Additional classpath that will be reloaded by TeaVM each time in wait mode").longOpt("classpath").build());
        options.addOption(Option.builder().argName("class name").hasArgs().desc("Tell optimizer to not remove class, so that it can be found by Class.forName").longOpt("preserve-class").build());
        options.addOption(Option.builder().longOpt("wasm-version").argName("version").hasArg().desc("WebAssembly binary version (currently, only 1 is supported)").build());
        options.addOption(Option.builder((String)"e").longOpt("entry-point").argName("name").hasArg().desc("Entry point name in target language (main by default)").build());
        options.addOption(Option.builder().longOpt("min-heap").argName("size").hasArg().desc("Minimum heap size in megabytes (for C and WebAssembly)").build());
        options.addOption(Option.builder().longOpt("max-heap").argName("size").hasArg().desc("Maximum heap size in megabytes (for C and WebAssembly)").build());
        options.addOption(Option.builder().longOpt("js-module-type").argName("module-type").hasArg().desc("JavaScript module type (umd, common-js, none, es2015).").build());
    }

    private TeaVMRunner(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        if (args.length == 0) {
            TeaVMRunner.printUsage();
            return;
        }
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMRunner.printUsage();
            return;
        }
        TeaVMRunner runner = new TeaVMRunner(commandLine);
        runner.parseArguments();
        runner.setUp();
        runner.runAll();
    }

    private void parseArguments() {
        this.parseClassPathOptions();
        this.parseTargetOption();
        this.parseOutputOptions();
        this.parseDebugOptions();
        this.parsePreserveClassOptions();
        this.parseOptimizationOption();
        this.parseIncrementalOptions();
        this.parseGenerationOptions();
        this.parseWasmOptions();
        this.parseCOptions();
        this.parseHeap();
        if (this.commandLine.hasOption("e")) {
            this.tool.setEntryPointName(this.commandLine.getOptionValue("e"));
        }
        this.interactive = this.commandLine.hasOption('w');
        String[] args = this.commandLine.getArgs();
        if (args.length > 1) {
            System.err.println("Unexpected arguments");
            TeaVMRunner.printUsage();
        } else if (args.length == 1) {
            this.tool.setMainClass(args[0]);
        }
    }

    private void parseTargetOption() {
        if (this.commandLine.hasOption("t")) {
            switch (this.commandLine.getOptionValue('t').toLowerCase()) {
                case "javascript": 
                case "js": {
                    this.tool.setTargetType(TeaVMTargetType.JAVASCRIPT);
                    break;
                }
                case "webassembly": 
                case "wasm": {
                    this.tool.setTargetType(TeaVMTargetType.WEBASSEMBLY);
                    break;
                }
                case "webassembly-wasi": 
                case "wasm-wasi": 
                case "wasi": {
                    this.tool.setTargetType(TeaVMTargetType.WEBASSEMBLY_WASI);
                    break;
                }
                case "c": {
                    this.tool.setTargetType(TeaVMTargetType.C);
                }
            }
        }
    }

    private void parseOutputOptions() {
        if (this.commandLine.hasOption("d")) {
            this.tool.setTargetDirectory(new File(this.commandLine.getOptionValue("d")));
        }
        if (this.commandLine.hasOption("f")) {
            this.tool.setTargetFileName(this.commandLine.getOptionValue("f"));
        }
    }

    private void parseGenerationOptions() {
        this.tool.setObfuscated(this.commandLine.hasOption("m"));
        this.tool.setStrict(this.commandLine.hasOption("strict"));
        this.parseJsModuleOption();
    }

    private void parseJsModuleOption() {
        if (!this.commandLine.hasOption("js-module-type")) {
            return;
        }
        switch (this.commandLine.getOptionValue("js-module-type")) {
            case "umd": {
                this.tool.setJsModuleType(JSModuleType.UMD);
                break;
            }
            case "common-js": {
                this.tool.setJsModuleType(JSModuleType.COMMON_JS);
                break;
            }
            case "none": {
                this.tool.setJsModuleType(JSModuleType.NONE);
                break;
            }
            case "es2015": {
                this.tool.setJsModuleType(JSModuleType.ES2015);
                break;
            }
            default: {
                System.err.print("Wrong JS module type level");
                TeaVMRunner.printUsage();
            }
        }
    }

    private void parseDebugOptions() {
        if (this.commandLine.hasOption('g')) {
            this.tool.setDebugInformationGenerated(true);
        }
        if (this.commandLine.hasOption('G')) {
            this.tool.setSourceMapsFileGenerated(true);
        }
    }

    private void parsePreserveClassOptions() {
        if (this.commandLine.hasOption("preserve-class")) {
            this.tool.getClassesToPreserve().addAll(Arrays.asList(this.commandLine.getOptionValues("preserve-class")));
        }
    }

    private void parseOptimizationOption() {
        if (this.commandLine.hasOption("O")) {
            int level;
            try {
                level = Integer.parseInt(this.commandLine.getOptionValue("O"));
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong optimization level");
                TeaVMRunner.printUsage();
                return;
            }
            switch (level) {
                case 1: {
                    this.tool.setOptimizationLevel(TeaVMOptimizationLevel.SIMPLE);
                    break;
                }
                case 2: {
                    this.tool.setOptimizationLevel(TeaVMOptimizationLevel.ADVANCED);
                    break;
                }
                case 3: {
                    this.tool.setOptimizationLevel(TeaVMOptimizationLevel.FULL);
                    break;
                }
                default: {
                    System.err.print("Wrong optimization level");
                    TeaVMRunner.printUsage();
                }
            }
        }
    }

    private void parseIncrementalOptions() {
        if (this.commandLine.hasOption('i')) {
            this.tool.setIncremental(true);
        }
        if (this.commandLine.hasOption('c')) {
            this.tool.setCacheDirectory(new File(this.commandLine.getOptionValue('c')));
        } else {
            this.tool.setCacheDirectory(new File(this.tool.getTargetDirectory(), "teavm-cache"));
        }
    }

    private void parseClassPathOptions() {
        if (this.commandLine.hasOption('p')) {
            this.classPath = this.commandLine.getOptionValues('p');
        }
    }

    private void parseWasmOptions() {
        if (this.commandLine.hasOption("wasm-version")) {
            String value = this.commandLine.getOptionValue("wasm-version");
            try {
                int version = Integer.parseInt(value);
                switch (version) {
                    case 1: {
                        this.tool.setWasmVersion(WasmBinaryVersion.V_0x1);
                        break;
                    }
                    default: {
                        System.err.print("Wrong version value");
                        TeaVMRunner.printUsage();
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong version value");
                TeaVMRunner.printUsage();
            }
        }
    }

    private void parseCOptions() {
        if (this.commandLine.hasOption("heap-dump")) {
            this.tool.setHeapDump(true);
        }
    }

    private void parseHeap() {
        int size;
        if (this.commandLine.hasOption("min-heap")) {
            try {
                size = Integer.parseInt(this.commandLine.getOptionValue("min-heap"));
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong heap size");
                TeaVMRunner.printUsage();
                return;
            }
            this.tool.setMinHeapSize(size * 1024 * 1024);
        }
        if (this.commandLine.hasOption("max-heap")) {
            try {
                size = Integer.parseInt(this.commandLine.getOptionValue("max-heap"));
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong heap size");
                TeaVMRunner.printUsage();
                return;
            }
            this.tool.setMaxHeapSize(size * 1024 * 1024);
        }
    }

    private void setUp() {
        this.tool.setLog((TeaVMToolLog)this.log);
        this.tool.getProperties().putAll((Map<?, ?>)System.getProperties());
    }

    private void runAll() {
        if (this.interactive) {
            this.buildInteractive();
        } else {
            this.buildNonInteractive();
        }
    }

    private void buildInteractive() {
        FileSystemWatcher watcher;
        try {
            watcher = new FileSystemWatcher(this.classPath);
        }
        catch (IOException e) {
            System.err.println("Error listening file system events");
            e.printStackTrace();
            System.exit(2);
            return;
        }
        while (true) {
            ProgressListenerImpl progressListener = new ProgressListenerImpl(watcher);
            try {
                this.build(progressListener);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            try {
                System.out.println("Waiting for changes...");
                watcher.waitForChange(750);
                watcher.grabChangedFiles();
                System.out.println();
                System.out.println("Changes detected. Recompiling...");
            }
            catch (IOException | InterruptedException e) {
                return;
            }
        }
    }

    private void buildNonInteractive() {
        try {
            this.build(new ProgressListenerImpl(null));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-2);
        }
        if (!this.tool.getProblemProvider().getSevereProblems().isEmpty()) {
            System.exit(-2);
        }
    }

    private void build(ProgressListenerImpl progressListener) throws TeaVMToolException {
        this.tool.setProgressListener((TeaVMProgressListener)progressListener);
        this.resetClassLoader();
        this.startTime = System.currentTimeMillis();
        this.phaseStartTime = System.currentTimeMillis();
        this.tool.generate();
        this.reportPhaseComplete();
        TeaVMProblemRenderer.describeProblems((CallGraph)this.tool.getDependencyInfo().getCallGraph(), (ProblemProvider)this.tool.getProblemProvider(), (TeaVMToolLog)this.log);
        this.log.flush();
        System.out.println("Build complete for " + (double)(System.currentTimeMillis() - this.startTime) / 1000.0 + " seconds");
    }

    private void resetClassLoader() {
        if (this.classPath == null || this.classPath.length == 0) {
            return;
        }
        URL[] urls = new URL[this.classPath.length];
        for (int i = 0; i < this.classPath.length; ++i) {
            try {
                urls[i] = new File(this.classPath[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                System.err.println("Illegal classpath entry: " + this.classPath[i]);
                System.exit(-1);
                return;
            }
        }
        this.tool.setClassLoader((ClassLoader)new URLClassLoader(urls, TeaVMRunner.class.getClassLoader()));
    }

    private void reportPhaseComplete() {
        System.out.println(" complete for " + (double)(System.currentTimeMillis() - this.phaseStartTime) / 1000.0 + " seconds");
        this.log.flush();
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMRunner.class.getName() + " [OPTIONS] [qualified.main.Class]", options);
        System.exit(-1);
    }

    static {
        TeaVMRunner.setupOptions();
    }

    class ProgressListenerImpl
    implements TeaVMProgressListener {
        private TeaVMPhase currentPhase;
        private FileSystemWatcher fileSystemWatcher;

        ProgressListenerImpl(FileSystemWatcher fileSystemWatcher) {
            this.fileSystemWatcher = fileSystemWatcher;
        }

        public TeaVMProgressFeedback progressReached(int progress) {
            return this.getStatus();
        }

        public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int count) {
            TeaVMRunner.this.log.flush();
            if (this.currentPhase != phase) {
                if (this.currentPhase != null) {
                    TeaVMRunner.this.reportPhaseComplete();
                }
                TeaVMRunner.this.phaseStartTime = System.currentTimeMillis();
                switch (phase) {
                    case DEPENDENCY_ANALYSIS: {
                        System.out.print("Analyzing classes...");
                        break;
                    }
                    case COMPILING: {
                        System.out.print("Compiling...");
                    }
                }
                this.currentPhase = phase;
            }
            return this.getStatus();
        }

        private TeaVMProgressFeedback getStatus() {
            try {
                if (this.fileSystemWatcher != null && this.fileSystemWatcher.hasChanges()) {
                    System.out.println("Classes changed during compilation. Canceling.");
                    return TeaVMProgressFeedback.CANCEL;
                }
                return TeaVMProgressFeedback.CONTINUE;
            }
            catch (IOException e) {
                throw new RuntimeException("IO error occurred");
            }
        }
    }
}

