/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import java.io.Serializable;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.zone.ZoneRules;
import org.threeten.bp.zone.ZoneRulesException;
import org.threeten.bp.zone.ZoneRulesProvider;

final class ZoneRegion
extends ZoneId
implements Serializable {
    private final String id;
    private final transient ZoneRules rules;

    private static ZoneRegion ofLenient(String zoneId) {
        if (zoneId.equals("Z") || zoneId.startsWith("+") || zoneId.startsWith("-")) {
            throw new DateTimeException("Invalid ID for region-based ZoneId, invalid format: " + zoneId);
        }
        if (zoneId.equals("UTC") || zoneId.equals("GMT") || zoneId.equals("UT")) {
            return new ZoneRegion(zoneId, ZoneOffset.UTC.getRules());
        }
        if (zoneId.startsWith("UTC+") || zoneId.startsWith("GMT+") || zoneId.startsWith("UTC-") || zoneId.startsWith("GMT-")) {
            ZoneOffset offset = ZoneOffset.of(zoneId.substring(3));
            if (offset.getTotalSeconds() == 0) {
                return new ZoneRegion(zoneId.substring(0, 3), offset.getRules());
            }
            return new ZoneRegion(zoneId.substring(0, 3) + offset.getId(), offset.getRules());
        }
        if (zoneId.startsWith("UT+") || zoneId.startsWith("UT-")) {
            ZoneOffset offset = ZoneOffset.of(zoneId.substring(2));
            if (offset.getTotalSeconds() == 0) {
                return new ZoneRegion("UT", offset.getRules());
            }
            return new ZoneRegion("UT" + offset.getId(), offset.getRules());
        }
        return ZoneRegion.ofId(zoneId, false);
    }

    static ZoneRegion ofId(String zoneId, boolean checkAvailable) {
        ZoneRules rules;
        block4: {
            Objects.requireNonNull(zoneId, "zoneId");
            if (!ZoneRegion.isValidId(zoneId)) {
                throw new DateTimeException("Invalid ID for region-based ZoneId, invalid format: " + zoneId);
            }
            rules = null;
            try {
                rules = ZoneRulesProvider.getRules(zoneId, true);
            }
            catch (ZoneRulesException ex) {
                if (zoneId.equals("GMT0")) {
                    rules = ZoneOffset.UTC.getRules();
                }
                if (!checkAvailable) break block4;
                throw ex;
            }
        }
        return new ZoneRegion(zoneId, rules);
    }

    private static boolean isValidId(String id) {
        if (id.length() < 2) {
            return false;
        }
        if (!ZoneRegion.isIdStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (ZoneRegion.isIdPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isIdPart(char c) {
        switch (c) {
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return ZoneRegion.isIdStart(c) || c >= '0' && c <= '9';
    }

    private static boolean isIdStart(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    ZoneRegion(String id, ZoneRules rules) {
        this.id = id;
        this.rules = rules;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ZoneRules getRules() {
        return this.rules != null ? this.rules : ZoneRulesProvider.getRules(this.id, false);
    }
}

