/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.deobfuscate.js;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.GeneratedLocation;
import org.teavm.debugging.information.SourceLocation;
import org.teavm.jso.JSBody;
import org.teavm.jso.ajax.XMLHttpRequest;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSObjects;
import org.teavm.jso.core.JSRegExp;
import org.teavm.jso.core.JSString;
import org.teavm.jso.typedarrays.ArrayBuffer;
import org.teavm.jso.typedarrays.Int8Array;
import org.teavm.model.MethodReference;
import org.teavm.tooling.deobfuscate.js.DeobfuscateFunction;
import org.teavm.tooling.deobfuscate.js.DeobfuscatorCallback;
import org.teavm.tooling.deobfuscate.js.Frame;
import org.teavm.tooling.deobfuscate.js.Int8ArrayInputStream;

public final class Deobfuscator {
    private static final JSRegExp FRAME_PATTERN = JSRegExp.create("(^ +at ([^(]+) *\\((.+):([0-9]+):([0-9]+)\\) *$)|(^([^@]*)@(.+):([0-9]+):([0-9]+)$)");
    private DebugInformation debugInformation;
    private String classesFileName;

    public Deobfuscator(ArrayBuffer buffer, String classesFileName) throws IOException {
        Int8Array array = Int8Array.create(buffer);
        this.debugInformation = DebugInformation.read(new Int8ArrayInputStream(array));
        this.classesFileName = classesFileName;
    }

    public static void main(String[] args) {
        Deobfuscator.loadDeobfuscator(args[0], args[1]);
    }

    private static void loadDeobfuscator(String fileName, String classesFileName) {
        XMLHttpRequest xhr = XMLHttpRequest.create();
        xhr.setResponseType("arraybuffer");
        xhr.onComplete(() -> Deobfuscator.installDeobfuscator((ArrayBuffer)xhr.getResponse().cast(), classesFileName));
        xhr.open("GET", fileName);
        xhr.send();
    }

    public Frame[] deobfuscate(String stack) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (String line : Deobfuscator.splitLines(stack)) {
            int columnNumber;
            int lineNumber;
            JSArray<JSString> groups = FRAME_PATTERN.exec(JSString.valueOf(line));
            if (groups == null) continue;
            int groupOffset = 1;
            if (JSObjects.isUndefined(groups.get(1))) {
                groupOffset = 6;
            }
            String functionName = ((JSString)groups.get(1 + groupOffset)).stringValue();
            String fileName = ((JSString)groups.get(2 + groupOffset)).stringValue();
            List<Frame> framesPerLine = Deobfuscator.deobfuscateFrames(this.debugInformation, this.classesFileName, fileName, lineNumber = Integer.parseInt(((JSString)groups.get(3 + groupOffset)).stringValue()), columnNumber = Integer.parseInt(((JSString)groups.get(4 + groupOffset)).stringValue()));
            if (framesPerLine == null) {
                framesPerLine = Arrays.asList(Deobfuscator.createDefaultFrame(fileName, functionName, lineNumber));
            }
            frames.addAll(framesPerLine);
        }
        return frames.toArray(new Frame[0]);
    }

    private static void installDeobfuscator(ArrayBuffer buffer, String classesFileName) {
        Deobfuscator deobfuscator;
        try {
            deobfuscator = new Deobfuscator(buffer, classesFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Deobfuscator.setDeobfuscateFunction(deobfuscator::deobfuscate);
        DeobfuscatorCallback callback = Deobfuscator.getCallback();
        if (callback != null) {
            callback.run();
        }
    }

    private static List<Frame> deobfuscateFrames(DebugInformation debugInformation, String classesFileName, String fileName, int lineNumber, int columnNumber) {
        GeneratedLocation jsLocation;
        MethodReference method;
        if (!fileName.equals(classesFileName)) {
            return null;
        }
        ArrayList<Frame> result = new ArrayList<Frame>();
        for (int layer = 0; layer < debugInformation.layerCount() && (method = debugInformation.getMethodAt(jsLocation = new GeneratedLocation(lineNumber - 1, columnNumber - 1), layer)) != null; ++layer) {
            String decodedFileName;
            SourceLocation location = debugInformation.getSourceLocation(jsLocation, layer);
            String string = decodedFileName = location != null ? location.getFileName() : null;
            if (decodedFileName != null) {
                decodedFileName = decodedFileName.substring(decodedFileName.lastIndexOf(47) + 1);
            }
            Frame frame = Deobfuscator.createEmptyFrame();
            frame.setClassName(method.getClassName());
            frame.setMethodName(method.getName());
            frame.setFileName(decodedFileName);
            if (location != null) {
                frame.setLineNumber(location.getLine());
            }
            result.add(frame);
        }
        if (result.isEmpty()) {
            return null;
        }
        Collections.reverse(result);
        return result;
    }

    private static Frame createDefaultFrame(String fileName, String functionName, int lineNumber) {
        Frame frame = Deobfuscator.createEmptyFrame();
        frame.setFileName(fileName);
        frame.setMethodName(functionName != null ? functionName : "<unknown function>");
        frame.setClassName("<JS>");
        frame.setLineNumber(lineNumber);
        return frame;
    }

    private static String[] splitLines(String text) {
        ArrayList<String> result = new ArrayList<String>();
        int index = 0;
        while (index < text.length()) {
            int next = text.indexOf(10, index);
            if (next < 0) {
                next = text.length();
            }
            result.add(text.substring(index, next));
            index = next + 1;
        }
        return result.toArray(new String[0]);
    }

    @JSBody(script="return {};")
    private static native Frame createEmptyFrame();

    @JSBody(params={"f"}, script="window.$rt_decodeStack = f;")
    private static native void setDeobfuscateFunction(DeobfuscateFunction var0);

    @JSBody(script="return typeof $teavm_deobfuscator_callback === 'function'? $teavm_deobfuscator_callback : null;")
    private static native DeobfuscatorCallback getCallback();
}

