/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.binary.DataStructure;
import org.teavm.backend.wasm.binary.DataType;
import org.teavm.backend.wasm.binary.DataValue;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.common.ServiceRepository;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.DefaultMetadataGeneratorContext;
import org.teavm.platform.plugin.ResourceTypeDescriptor;
import org.teavm.platform.plugin.ResourceTypeDescriptorProvider;

class MetadataIntrinsic
implements WasmIntrinsic {
    private ClassReaderSource classSource;
    private ClassLoader classLoader;
    private ServiceRepository services;
    private Properties properties;
    private Map<ResourceTypeDescriptor, DataStructure> resourceTypeCache = new HashMap<ResourceTypeDescriptor, DataStructure>();
    private MethodReference constructor;
    private MethodReference targetMethod;
    private MetadataGenerator generator;

    MetadataIntrinsic(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Properties properties, MethodReference constructor, MethodReference targetMethod, MetadataGenerator generator) {
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.services = services;
        this.properties = properties;
        this.constructor = constructor;
        this.targetMethod = targetMethod;
        this.generator = generator;
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        return methodReference.equals(this.constructor);
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        DefaultMetadataGeneratorContext metadataContext = new DefaultMetadataGeneratorContext(this.classSource, this.classLoader, this.properties, this.services);
        Resource resource = this.generator.generateMetadata(metadataContext, this.targetMethod);
        int address = this.writeValue(manager.getBinaryWriter(), manager.getStringPool(), resource);
        return new WasmInt32Constant(address);
    }

    private int writeValue(BinaryWriter writer, WasmStringPool stringPool, Object value) {
        if (value instanceof String) {
            return stringPool.getStringPointer((String)value);
        }
        if (value instanceof Boolean) {
            DataValue dataValue = DataPrimitives.BYTE.createValue();
            dataValue.setByte(0, (Boolean)value != false ? (byte)1 : 0);
            return writer.append(dataValue);
        }
        if (value instanceof Integer) {
            DataValue dataValue = DataPrimitives.INT.createValue();
            dataValue.setInt(0, (Integer)value);
            return writer.append(dataValue);
        }
        if (value instanceof Long) {
            DataValue dataValue = DataPrimitives.LONG.createValue();
            dataValue.setLong(0, (Long)value);
            return writer.append(dataValue);
        }
        if (value instanceof ResourceMap) {
            return this.writeResource(writer, stringPool, (ResourceMap)value);
        }
        if (value instanceof ResourceArray) {
            return this.writeResource(writer, stringPool, (ResourceArray)value);
        }
        if (value instanceof ResourceTypeDescriptorProvider && value instanceof Resource) {
            return this.writeResource(writer, stringPool, (ResourceTypeDescriptorProvider)value);
        }
        throw new IllegalArgumentException("Don't know how to write resource: " + value);
    }

    private int writeResource(BinaryWriter writer, WasmStringPool stringPool, ResourceTypeDescriptorProvider resourceType) {
        DataStructure structure = this.getDataStructure(resourceType.getDescriptor());
        DataValue value = structure.createValue();
        int address = writer.append(value);
        Object[] propertyValues = resourceType.getValues();
        for (String propertyName : resourceType.getDescriptor().getPropertyTypes().keySet()) {
            Class<?> propertyType = resourceType.getDescriptor().getPropertyTypes().get(propertyName);
            int index = resourceType.getPropertyIndex(propertyName);
            Object propertyValue = propertyValues[index];
            this.writeValueTo(writer, stringPool, propertyType, value, index, propertyValue);
        }
        return address;
    }

    private int writeResource(BinaryWriter writer, WasmStringPool stringPool, ResourceMap<?> resourceMap) {
        int i;
        int tableSize;
        String[] keys = resourceMap.keys();
        int maxTableSize = Math.min(keys.length * 5 / 2, tableSize + 10);
        String[] bestTable = null;
        int bestCollisionRatio = 0;
        for (tableSize = keys.length * 2; tableSize <= maxTableSize; ++tableSize) {
            String[] table = new String[tableSize];
            int maxCollisionRatio = 0;
            for (String key : keys) {
                int hashCode = key.hashCode();
                int collisionRatio = 0;
                while (true) {
                    int index;
                    if (table[index = MetadataIntrinsic.mod(hashCode++, table.length)] == null) break;
                    ++collisionRatio;
                }
                table[index] = key;
                maxCollisionRatio = Math.max(maxCollisionRatio, collisionRatio);
            }
            if (bestTable != null && bestCollisionRatio <= maxCollisionRatio) continue;
            bestCollisionRatio = maxCollisionRatio;
            bestTable = table;
        }
        DataValue sizeValue = DataPrimitives.ADDRESS.createValue();
        int start = writer.append(sizeValue);
        sizeValue.setAddress(0, bestTable.length);
        DataValue[] keyValues = new DataValue[bestTable.length];
        DataValue[] valueValues = new DataValue[bestTable.length];
        for (i = 0; i < bestTable.length; ++i) {
            DataValue keyValue = DataPrimitives.ADDRESS.createValue();
            DataValue valueValue = DataPrimitives.ADDRESS.createValue();
            writer.append(keyValue);
            writer.append(valueValue);
            keyValues[i] = keyValue;
            valueValues[i] = valueValue;
        }
        for (i = 0; i < bestTable.length; ++i) {
            String key;
            key = bestTable[i];
            if (key == null) continue;
            keyValues[i].setAddress(0, stringPool.getStringPointer(key));
            valueValues[i].setAddress(0, this.writeValue(writer, stringPool, resourceMap.get(key)));
        }
        return start;
    }

    private int writeResource(BinaryWriter writer, WasmStringPool stringPool, ResourceArray<?> resourceArray) {
        int i;
        DataValue sizeValue = DataPrimitives.ADDRESS.createValue();
        int start = writer.append(sizeValue);
        sizeValue.setAddress(0, resourceArray.size());
        DataValue[] arrayValues = new DataValue[resourceArray.size()];
        for (i = 0; i < resourceArray.size(); ++i) {
            arrayValues[i] = DataPrimitives.ADDRESS.createValue();
            writer.append(arrayValues[i]);
        }
        for (i = 0; i < resourceArray.size(); ++i) {
            arrayValues[i].setAddress(0, this.writeValue(writer, stringPool, resourceArray.get(i)));
        }
        return start;
    }

    private static int mod(int a, int b) {
        if ((a %= b) < 0) {
            a += b;
        }
        return a;
    }

    private void writeValueTo(BinaryWriter writer, WasmStringPool stringPool, Class<?> type, DataValue target, int index, Object value) {
        if (type == String.class) {
            target.setAddress(index, value != null ? (long)stringPool.getStringPointer((String)value) : 0L);
        } else if (type == Boolean.TYPE) {
            target.setByte(index, (Boolean)value != false ? (byte)1 : 0);
        } else if (type == Byte.TYPE) {
            target.setByte(index, (Byte)value);
        } else if (type == Short.TYPE) {
            target.setShort(index, (Short)value);
        } else if (type == Character.TYPE) {
            target.setShort(index, (short)((Character)value).charValue());
        } else if (type == Integer.TYPE) {
            target.setInt(index, (Integer)value);
        } else if (type == Long.TYPE) {
            target.setLong(index, (Long)value);
        } else if (type == Float.TYPE) {
            target.setFloat(index, ((Float)value).floatValue());
        } else if (type == Double.TYPE) {
            target.setDouble(index, (Double)value);
        } else if (value instanceof ResourceTypeDescriptorProvider && value instanceof Resource) {
            int address = this.writeResource(writer, stringPool, (ResourceTypeDescriptorProvider)value);
            target.setAddress(index, address);
        } else if (value == null) {
            target.setAddress(index, 0L);
        } else if (value instanceof ResourceMap) {
            target.setAddress(index, this.writeResource(writer, stringPool, (ResourceMap)value));
        } else if (value instanceof ResourceArray) {
            target.setAddress(index, this.writeResource(writer, stringPool, (ResourceArray)value));
        } else {
            throw new IllegalArgumentException("Don't know how to write resource: " + value);
        }
    }

    private DataStructure getDataStructure(ResourceTypeDescriptor descriptor) {
        return this.resourceTypeCache.computeIfAbsent(descriptor, t -> {
            ArrayList<String> propertyNames = new ArrayList<String>(descriptor.getPropertyTypes().keySet());
            DataType[] propertyDataTypes = new DataType[propertyNames.size()];
            for (int i = 0; i < propertyNames.size(); ++i) {
                String propertyName = (String)propertyNames.get(i);
                propertyDataTypes[i] = MetadataIntrinsic.getDataType(descriptor.getPropertyTypes().get(propertyName));
            }
            return new DataStructure(4, propertyDataTypes);
        });
    }

    private static DataType getDataType(Class<?> cls) {
        if (cls == Boolean.TYPE || cls == Byte.TYPE) {
            return DataPrimitives.BYTE;
        }
        if (cls == Short.TYPE || cls == Character.TYPE) {
            return DataPrimitives.SHORT;
        }
        if (cls == Integer.TYPE) {
            return DataPrimitives.INT;
        }
        if (cls == Float.TYPE) {
            return DataPrimitives.FLOAT;
        }
        if (cls == Long.TYPE) {
            return DataPrimitives.LONG;
        }
        if (cls == Double.TYPE) {
            return DataPrimitives.DOUBLE;
        }
        return DataPrimitives.ADDRESS;
    }
}

