/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.instructions;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.Variable;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.SwitchTableEntry;

public class SwitchInstruction
extends Instruction {
    private Variable condition;
    private List<SwitchTableEntry> entries = new ArrayList<SwitchTableEntry>();
    private BasicBlock defaultTarget;
    private List<SwitchTableEntry> safeEntries = new AbstractList<SwitchTableEntry>(){

        @Override
        public SwitchTableEntry set(int index, SwitchTableEntry element) {
            SwitchTableEntry oldElement = (SwitchTableEntry)SwitchInstruction.this.entries.get(index);
            oldElement.setInstruction(null);
            SwitchInstruction.this.entries.set(index, element);
            element.setInstruction(SwitchInstruction.this);
            return oldElement;
        }

        @Override
        public void add(int index, SwitchTableEntry element) {
            SwitchInstruction.this.entries.add(index, element);
            element.setInstruction(SwitchInstruction.this);
        }

        @Override
        public SwitchTableEntry remove(int index) {
            SwitchTableEntry element = (SwitchTableEntry)SwitchInstruction.this.entries.remove(index);
            element.setInstruction(null);
            return element;
        }

        @Override
        public void clear() {
            for (SwitchTableEntry element : SwitchInstruction.this.entries) {
                element.setInstruction(null);
            }
            SwitchInstruction.this.entries.clear();
        }

        @Override
        public SwitchTableEntry get(int index) {
            return (SwitchTableEntry)SwitchInstruction.this.entries.get(index);
        }

        @Override
        public int size() {
            return SwitchInstruction.this.entries.size();
        }
    };

    public Variable getCondition() {
        return this.condition;
    }

    public void setCondition(Variable condition) {
        this.condition = condition;
    }

    public List<SwitchTableEntry> getEntries() {
        return this.safeEntries;
    }

    public BasicBlock getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(BasicBlock defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    @Override
    public void acceptVisitor(InstructionVisitor visitor) {
        visitor.visit(this);
    }
}

