/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.DoubleIntHashMap;
import org.teavm.hppc.HashOrderMixing;

public class DoubleIntScatterMap
extends DoubleIntHashMap {
    public DoubleIntScatterMap() {
        this(4);
    }

    public DoubleIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(double key) {
        return BitMixer.mixPhi(key);
    }

    public static DoubleIntScatterMap from(double[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleIntScatterMap map = new DoubleIntScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

