/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.PrimitiveIterator;
import java.util.function.Function;
import java.util.function.LongPredicate;
import org.teavm.classlib.java.util.stream.TLongStream;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;

public class TFlatMappingToLongStreamImpl<T>
extends TSimpleLongStreamImpl {
    private TSimpleStreamImpl<T> sourceStream;
    private TLongStream current;
    private boolean currentSet;
    private PrimitiveIterator.OfLong iterator;
    private Function<? super T, ? extends TLongStream> mapper;
    private boolean done;

    public TFlatMappingToLongStreamImpl(TSimpleStreamImpl<T> sourceStream, Function<? super T, ? extends TLongStream> mapper) {
        this.sourceStream = sourceStream;
        this.mapper = mapper;
    }

    @Override
    public boolean next(LongPredicate consumer) {
        if (this.current == null) {
            if (this.done) {
                return false;
            }
            this.currentSet = false;
            while (!this.currentSet) {
                boolean hasMore = this.sourceStream.next((? super T e) -> {
                    this.current = this.mapper.apply(e);
                    this.currentSet = true;
                    return false;
                });
                if (hasMore) continue;
                this.done = true;
                break;
            }
            if (this.current == null) {
                return false;
            }
        }
        if (this.current instanceof TSimpleLongStreamImpl) {
            TSimpleLongStreamImpl castCurrent = (TSimpleLongStreamImpl)this.current;
            if (castCurrent.next(consumer)) {
                return true;
            }
            this.current = null;
        } else {
            this.iterator = this.current.iterator();
            while (this.iterator.hasNext()) {
                long e2 = this.iterator.next();
                if (consumer.test(e2)) continue;
                return true;
            }
            this.iterator = null;
            this.current = null;
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        this.current = null;
        this.iterator = null;
        this.sourceStream.close();
    }
}

