/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import org.teavm.classlib.java.util.regex.TAbstractCharClass;
import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TCharSet;
import org.teavm.classlib.java.util.regex.TJointSet;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;
import org.teavm.classlib.java.util.regex.TRangeSet;
import org.teavm.classlib.java.util.regex.TSupplCharSet;

class TSupplRangeSet
extends TJointSet {
    protected TAbstractCharClass chars;
    protected boolean alt;

    public TSupplRangeSet(TAbstractCharClass cs, TAbstractSet next) {
        this.chars = cs.getInstance();
        this.alt = cs.alt;
        this.next = next;
    }

    public TSupplRangeSet(TAbstractCharClass cc) {
        this.chars = cc.getInstance();
        this.alt = cc.alt;
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        int strLength = matchResult.getRightBound();
        if (stringIndex < strLength) {
            char low;
            int offset;
            char high;
            if (this.contains(high = testString.charAt(stringIndex++)) && (offset = this.next.matches(stringIndex, testString, matchResult)) > 0) {
                return offset;
            }
            if (stringIndex < strLength && Character.isSurrogatePair(high, low = testString.charAt(stringIndex++)) && this.contains(Character.toCodePoint(high, low))) {
                return this.next.matches(stringIndex, testString, matchResult);
            }
        }
        return -1;
    }

    @Override
    protected String getName() {
        return "range:" + (this.alt ? "^ " : " ") + this.chars.toString();
    }

    public boolean contains(int ch) {
        return this.chars.contains(ch);
    }

    @Override
    public boolean first(TAbstractSet set) {
        if (set instanceof TSupplCharSet) {
            return TAbstractCharClass.intersects(this.chars, ((TSupplCharSet)set).getCodePoint());
        }
        if (set instanceof TCharSet) {
            return TAbstractCharClass.intersects(this.chars, (int)((TCharSet)set).getChar());
        }
        if (set instanceof TSupplRangeSet) {
            return TAbstractCharClass.intersects(this.chars, ((TSupplRangeSet)set).chars);
        }
        if (set instanceof TRangeSet) {
            return TAbstractCharClass.intersects(this.chars, ((TRangeSet)set).getChars());
        }
        return true;
    }

    protected TAbstractCharClass getChars() {
        return this.chars;
    }

    @Override
    public TAbstractSet getNext() {
        return this.next;
    }

    @Override
    public void setNext(TAbstractSet next) {
        this.next = next;
    }

    @Override
    public boolean hasConsumed(TMatchResultImpl mr) {
        return true;
    }
}

