/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.invoke;

import java.io.Serializable;
import java.lang.invoke.MethodHandleInfo;
import java.util.Objects;

public final class TSerializedLambda
implements Serializable {
    private static final long serialVersionUID = 8025925345765570181L;
    private final Class<?> capturingClass;
    private final String functionalInterfaceClass;
    private final String functionalInterfaceMethodName;
    private final String functionalInterfaceMethodSignature;
    private final String implClass;
    private final String implMethodName;
    private final String implMethodSignature;
    private final int implMethodKind;
    private final String instantiatedMethodType;
    private final Object[] capturedArgs;

    public TSerializedLambda(Class<?> capturingClass, String functionalInterfaceClass, String functionalInterfaceMethodName, String functionalInterfaceMethodSignature, int implMethodKind, String implClass, String implMethodName, String implMethodSignature, String instantiatedMethodType, Object[] capturedArgs) {
        this.capturingClass = capturingClass;
        this.functionalInterfaceClass = functionalInterfaceClass;
        this.functionalInterfaceMethodName = functionalInterfaceMethodName;
        this.functionalInterfaceMethodSignature = functionalInterfaceMethodSignature;
        this.implMethodKind = implMethodKind;
        this.implClass = implClass;
        this.implMethodName = implMethodName;
        this.implMethodSignature = implMethodSignature;
        this.instantiatedMethodType = instantiatedMethodType;
        this.capturedArgs = (Object[])Objects.requireNonNull(capturedArgs).clone();
    }

    public String getCapturingClass() {
        return this.capturingClass.getName().replace('.', '/');
    }

    public String getFunctionalInterfaceClass() {
        return this.functionalInterfaceClass;
    }

    public String getFunctionalInterfaceMethodName() {
        return this.functionalInterfaceMethodName;
    }

    public String getFunctionalInterfaceMethodSignature() {
        return this.functionalInterfaceMethodSignature;
    }

    public String getImplClass() {
        return this.implClass;
    }

    public String getImplMethodName() {
        return this.implMethodName;
    }

    public String getImplMethodSignature() {
        return this.implMethodSignature;
    }

    public int getImplMethodKind() {
        return this.implMethodKind;
    }

    public String getInstantiatedMethodType() {
        return this.instantiatedMethodType;
    }

    public int getCapturedArgCount() {
        return this.capturedArgs.length;
    }

    public Object getCapturedArg(int i) {
        return this.capturedArgs[i];
    }

    private Object readResolve() throws ReflectiveOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        String implKind = MethodHandleInfo.referenceKindToString(this.implMethodKind);
        return "SerializedLambda[capturingClass=" + this.capturingClass + ", functionalInterfaceMethod=" + this.functionalInterfaceClass + "." + this.functionalInterfaceMethodName + ":" + this.functionalInterfaceMethodSignature + ", implementation=" + implKind + " " + this.implClass + "." + this.implMethodName + ":" + this.implMethodSignature + ", instantiatedMethodType=" + this.instantiatedMethodType + ", numCaptured=" + this.capturedArgs.length + "]";
    }
}

