/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.classlib.java.lang.DoubleGenerator;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.interop.Import;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;

@NoSideEffects
public class TDouble
extends TNumber
implements TComparable<TDouble> {
    public static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    public static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    public static final double NaN = TDouble.getNaN();
    public static final double MAX_VALUE = Double.MAX_VALUE;
    public static final double MIN_NORMAL = -4.49423283715579E307;
    public static final double MIN_VALUE = Double.MIN_VALUE;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_EXPONENT = -1022;
    public static final int SIZE = 64;
    public static final Class<Double> TYPE = Double.TYPE;
    private double value;

    public TDouble(double value) {
        this.value = value;
    }

    public TDouble(TString value) throws TNumberFormatException {
        this.value = TDouble.parseDouble(value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    public static TDouble valueOf(double d) {
        return new TDouble(d);
    }

    public static String toString(double d) {
        return new TStringBuilder().append(d).toString();
    }

    public static TDouble valueOf(TString string) {
        return TDouble.valueOf(TDouble.parseDouble(string));
    }

    public static double parseDouble(TString string) throws TNumberFormatException {
        if (string.isEmpty()) {
            throw new TNumberFormatException();
        }
        int start = 0;
        int end = string.length();
        while (string.charAt(start) <= ' ') {
            if (++start != end) continue;
            throw new TNumberFormatException();
        }
        while (string.charAt(end - 1) <= ' ') {
            --end;
        }
        boolean negative = false;
        int index = start;
        if (string.charAt(index) == '-') {
            ++index;
            negative = true;
        } else if (string.charAt(index) == '+') {
            ++index;
        }
        if (index == end) {
            throw new TNumberFormatException();
        }
        char c = string.charAt(index);
        long mantissa = 0L;
        int exp = 0;
        boolean hasOneDigit = false;
        if (c != '.') {
            hasOneDigit = true;
            if (c < '0' || c > '9') {
                throw new TNumberFormatException();
            }
            while (index < end && string.charAt(index) == '0') {
                ++index;
            }
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                if (mantissa < 0xCCCCCCCCCCCCCC3L) {
                    mantissa = mantissa * 10L + (long)(c - 48);
                } else {
                    ++exp;
                }
                ++index;
            }
        }
        if (index < end && string.charAt(index) == '.') {
            ++index;
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                if (mantissa < 0xCCCCCCCCCCCCCC3L) {
                    mantissa = mantissa * 10L + (long)(c - 48);
                    --exp;
                }
                ++index;
                hasOneDigit = true;
            }
            if (!hasOneDigit) {
                throw new TNumberFormatException();
            }
        }
        if (index < end) {
            c = string.charAt(index);
            if (c != 'e' && c != 'E') {
                throw new TNumberFormatException();
            }
            boolean negativeExp = false;
            if (++index == end) {
                throw new TNumberFormatException();
            }
            if (string.charAt(index) == '-') {
                ++index;
                negativeExp = true;
            } else if (string.charAt(index) == '+') {
                ++index;
            }
            int numExp = 0;
            hasOneDigit = false;
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                numExp = 10 * numExp + (c - 48);
                hasOneDigit = true;
                ++index;
            }
            if (!hasOneDigit) {
                throw new TNumberFormatException();
            }
            if (negativeExp) {
                numExp = -numExp;
            }
            exp += numExp;
        }
        if (exp > 308 || exp == 308 && mantissa > 17976931348623157L) {
            return !negative ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (negative) {
            mantissa = -mantissa;
        }
        return (double)mantissa * TDouble.decimalExponent(exp);
    }

    public static double decimalExponent(int n) {
        double d;
        if (n < 0) {
            d = 0.1;
            n = -n;
        } else {
            d = 10.0;
        }
        double result = 1.0;
        while (n != 0) {
            if (n % 2 != 0) {
                result *= d;
            }
            d *= d;
            n /= 2;
        }
        return result;
    }

    @Override
    public String toString() {
        return TDouble.toString(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TDouble && ((TDouble)other).value == this.value;
    }

    @Override
    public int hashCode() {
        return TDouble.hashCode(this.value);
    }

    public static int hashCode(double d) {
        long h = TDouble.doubleToLongBits(d);
        return (int)(h >>> 32) ^ (int)h;
    }

    @NoSideEffects
    public static native int compare(double var0, double var2);

    @Override
    public int compareTo(TDouble other) {
        return TDouble.compare(this.value, other.value);
    }

    public boolean isNaN() {
        return TDouble.isNaN(this.value);
    }

    public boolean isInfinite() {
        return TDouble.isInfinite(this.value);
    }

    @JSBody(params={"v"}, script="return isNaN(v);")
    @Import(module="teavm", name="isnan")
    @NoSideEffects
    @Unmanaged
    public static native boolean isNaN(double var0);

    @JSBody(script="return NaN;")
    @Import(module="teavm", name="teavm_getNaN")
    @NoSideEffects
    @Unmanaged
    private static native double getNaN();

    @JSBody(params={"v"}, script="return !isFinite(v);")
    @Import(module="teavm", name="isinf")
    @NoSideEffects
    @Unmanaged
    public static native boolean isInfinite(double var0);

    @JSBody(params={"v"}, script="return isFinite(v);")
    @Import(module="teavm", name="isfinite")
    @NoSideEffects
    @Unmanaged
    public static native boolean isFinite(double var0);

    public static long doubleToRawLongBits(double value) {
        return TDouble.doubleToLongBits(value);
    }

    @InjectedBy(value=DoubleGenerator.class)
    @Import(name="teavm_reinterpretDoubleToLong")
    @NoSideEffects
    @Unmanaged
    public static native long doubleToLongBits(double var0);

    @InjectedBy(value=DoubleGenerator.class)
    @Import(name="teavm_reinterpretLongToDouble")
    @NoSideEffects
    @Unmanaged
    public static native double longBitsToDouble(long var0);

    public static String toHexString(double d) {
        if (TDouble.isNaN(d)) {
            return "NaN";
        }
        if (TDouble.isInfinite(d)) {
            return d > 0.0 ? "Infinity" : "-Infinity";
        }
        char[] buffer = new char[30];
        int sz = 0;
        long bits = TDouble.doubleToLongBits(d);
        boolean subNormal = false;
        int exp = (int)(bits >>> 52 & 0x7FFL) - 1023;
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        if (exp == -1023) {
            ++exp;
            subNormal = true;
        }
        for (int i = 0; i < 13; ++i) {
            int digit = (int)(mantissa & 0xFL);
            if (digit > 0 || sz > 0) {
                buffer[sz++] = TCharacter.forDigit(digit, 16);
            }
            mantissa >>>= 4;
        }
        if (sz == 0) {
            buffer[sz++] = 48;
        }
        buffer[sz++] = 46;
        buffer[sz++] = subNormal ? 48 : 49;
        buffer[sz++] = 120;
        buffer[sz++] = 48;
        if ((bits & Long.MIN_VALUE) != 0L) {
            buffer[sz++] = 45;
        }
        int half = sz / 2;
        for (int i = 0; i < half; ++i) {
            char tmp = buffer[i];
            buffer[i] = buffer[sz - i - 1];
            buffer[sz - i - 1] = tmp;
        }
        buffer[sz++] = 112;
        if (exp < 0) {
            exp = -exp;
            buffer[sz++] = 45;
        }
        int pos = 1000;
        boolean first = true;
        for (int i = 0; i < 4; ++i) {
            int digit = exp / pos;
            if (digit > 0 || !first) {
                buffer[sz++] = TCharacter.forDigit(digit, 10);
                first = false;
            }
            exp %= pos;
            pos /= 10;
        }
        if (first) {
            buffer[sz++] = 48;
        }
        return new String(buffer, 0, sz);
    }
}

