/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.teavm.classlib.ServiceLoaderFilter;
import org.teavm.classlib.impl.ServiceLoaderInformation;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.CallLocation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class ServiceLoaderSupport
extends AbstractDependencyListener
implements ServiceLoaderInformation {
    private static final MethodReference LOAD_METHOD = new MethodReference(ServiceLoader.class, "load", Class.class, ServiceLoader.class);
    private static final MethodDescriptor INIT_METHOD = new MethodDescriptor("<init>", Void.TYPE);
    private Map<String, List<String>> serviceMap = new HashMap<String, List<String>>();
    private ClassLoader classLoader;

    public ServiceLoaderSupport(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Collection<? extends String> serviceTypes() {
        return this.serviceMap.keySet();
    }

    @Override
    public Collection<? extends String> serviceImplementations(String type) {
        List result = this.serviceMap.get(type);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        MethodReference ref = method.getReference();
        if (ref.getClassName().equals("java.util.ServiceLoader") && ref.getName().equals("loadServices")) {
            List<ServiceLoaderFilter> filters = this.getFilters(agent);
            method.getResult().propagate(agent.getType("[Ljava/lang/Object;"));
            DependencyNode sourceNode = agent.linkMethod(LOAD_METHOD).getVariable(1).getClassValueNode();
            sourceNode.connect(method.getResult().getArrayItem());
            sourceNode.addConsumer(type -> {
                CallLocation location = new CallLocation(LOAD_METHOD);
                for (String implementationType : this.getImplementations(type.getName())) {
                    if (filters.stream().anyMatch(filter -> !filter.apply(type.getName(), implementationType))) continue;
                    this.serviceMap.computeIfAbsent(type.getName(), k -> new ArrayList()).add(implementationType);
                    MethodReference ctor = new MethodReference(implementationType, INIT_METHOD);
                    agent.linkMethod(ctor).addLocation(location).use();
                    method.getResult().getArrayItem().propagate(agent.getType(implementationType));
                }
            });
        }
    }

    private Set<String> getImplementations(String type) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try {
            Enumeration<URL> resources = this.classLoader.getResources("META-INF/services/" + type);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                InputStream stream = resource.openStream();
                try {
                    this.parseServiceFile(stream, result);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void parseServiceFile(InputStream input, Set<String> consumer) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            consumer.add(line);
        }
    }

    private List<ServiceLoaderFilter> getFilters(DependencyAgent agent) {
        ArrayList<ServiceLoaderFilter> filters = new ArrayList<ServiceLoaderFilter>();
        for (String filterTypeName : this.getImplementations(ServiceLoaderFilter.class.getName())) {
            Class<?> filterType;
            try {
                filterType = Class.forName(filterTypeName, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                agent.getDiagnostics().error(null, "Could not load ServiceLoader filter class '{{c0}}'", filterTypeName);
                continue;
            }
            if (!ServiceLoaderFilter.class.isAssignableFrom(filterType)) {
                agent.getDiagnostics().error(null, "Class '{{c0}}' does not implement ServiceLoaderFilter interface", filterTypeName);
                continue;
            }
            try {
                filters.add((ServiceLoaderFilter)filterType.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                agent.getDiagnostics().error(null, "Could not instantiate ServiceLoader filter '{{c0}}'", filterTypeName);
            }
        }
        return filters;
    }
}

