/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.Collection;
import java.util.ServiceLoader;
import org.teavm.backend.c.generate.CodeWriter;
import org.teavm.backend.c.generators.Generator;
import org.teavm.backend.c.generators.GeneratorContext;
import org.teavm.backend.c.generators.GeneratorFactory;
import org.teavm.backend.c.generators.GeneratorFactoryContext;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.classlib.impl.ServiceLoaderInformation;
import org.teavm.interop.Address;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.CallSiteLocation;
import org.teavm.model.lowlevel.ExceptionHandlerDescriptor;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.RuntimeClass;

public class ServiceLoaderCSupport
implements GeneratorFactory {
    static final MethodReference ALLOC_ARRAY_METHOD = new MethodReference(Allocator.class, "allocateArray", RuntimeClass.class, Integer.TYPE, Address.class);
    static final MethodReference ALLOC_METHOD = new MethodReference(Allocator.class, "allocate", RuntimeClass.class, Address.class);
    static final MethodDescriptor INIT_METHOD = new MethodDescriptor("<init>", ValueType.VOID);

    @Override
    public Generator createGenerator(GeneratorFactoryContext context) {
        return new ServiceLoaderIntrinsic(context.getServices().getService(ServiceLoaderInformation.class));
    }

    static class ServiceLoaderIntrinsic
    implements Generator {
        private ServiceLoaderInformation information;

        ServiceLoaderIntrinsic(ServiceLoaderInformation information) {
            this.information = information;
        }

        @Override
        public boolean canHandle(MethodReference method) {
            if (!method.getClassName().equals(ServiceLoader.class.getName())) {
                return false;
            }
            return method.getName().equals("loadServices");
        }

        @Override
        public void generate(GeneratorContext context, MethodReference method) {
            CodeWriter writer = context.writer();
            CodeWriter beforeWriter = context.writerBefore();
            NameProvider names = context.names();
            context.includes().addInclude("<stdbool.h>");
            Collection<? extends String> serviceTypes = this.information.serviceTypes();
            writer.println("static bool initialized = false;");
            writer.println("if (!initialized) {").indent();
            String methodName = names.forMethod(method);
            int index = 0;
            for (String string : serviceTypes) {
                Collection<? extends String> implementations = this.information.serviceImplementations(string);
                if (implementations.isEmpty()) continue;
                String staticFieldName = methodName + "_" + index++;
                context.includes().includeClass(string);
                writer.print(names.forClassInstance(ValueType.object(string))).print(".services = (TeaVM_Services*) &").print(staticFieldName).println(";");
                beforeWriter.print("static struct { int32_t size; ").print("TeaVM_Service entries[" + implementations.size() + "]; } ").print(staticFieldName + " = { .size = " + implementations.size() + ", ").print(".entries = {").indent();
                boolean first = true;
                for (String string2 : implementations) {
                    if (!first) {
                        beforeWriter.print(",");
                    }
                    first = false;
                    context.includes().includeClass(string2);
                    MethodReference constructor = new MethodReference(string2, INIT_METHOD);
                    context.importMethod(constructor, false);
                    beforeWriter.println().print("{ .cls = (TeaVM_Class*) &").print(names.forClassInstance(ValueType.object(string2))).print(", .constructor = &").print(names.forMethod(constructor)).print(" }");
                }
                if (!first) {
                    beforeWriter.println();
                }
                beforeWriter.outdent().println("}};");
            }
            writer.outdent().println("}");
            CallSiteLocation location = new CallSiteLocation(null, method.getClassName(), method.getName(), -1);
            CallSiteDescriptor callSiteDescriptor = context.createCallSite(new CallSiteLocation[]{location}, new ExceptionHandlerDescriptor[0]);
            writer.println("TEAVM_ALLOC_STACK(INT32_C(2));");
            writer.println("TEAVM_CALL_SITE(" + callSiteDescriptor.getId() + ");");
            writer.println("TeaVM_Array* result = NULL;");
            writer.print("TeaVM_Services* services = ((TeaVM_Class*) ").print(context.parameterName(1)).println(")->services;");
            writer.println("if (services == NULL) goto exit;");
            writer.println("TEAVM_GC_ROOT_RELEASE(0);");
            writer.println("TEAVM_GC_ROOT_RELEASE(1);");
            writer.print("result = ").print(names.forMethod(ALLOC_ARRAY_METHOD)).print("(&").print(names.forClassInstance(ValueType.parse(Object[].class))).print(", ").println("services->size);");
            if (!context.usesLongjmp()) {
                writer.println("if (TEAVM_EXCEPTION_HANDLER != " + callSiteDescriptor.getId() + ") goto exit;");
            }
            writer.println("TEAVM_GC_ROOT(0, result);");
            writer.println("void** arrayData = (void**) TEAVM_ARRAY_DATA(result, void*);");
            writer.println("for (int32_t i = 0; i < services->size; ++i) {").indent();
            writer.print("void* obj = ").print(names.forMethod(ALLOC_METHOD)).println("(services->entries[i].cls);");
            if (!context.usesLongjmp()) {
                writer.println("if (TEAVM_EXCEPTION_HANDLER != " + callSiteDescriptor.getId() + ") goto exit;");
            }
            writer.println("TEAVM_GC_ROOT(1, obj);");
            writer.println("services->entries[i].constructor(obj);");
            if (!context.usesLongjmp()) {
                writer.println("if (TEAVM_EXCEPTION_HANDLER != " + callSiteDescriptor.getId() + ") goto exit;");
            }
            writer.println("arrayData[i] = obj;");
            writer.outdent().println("}");
            writer.println("exit: TEAVM_RELEASE_STACK;");
            writer.println("return result;");
        }
    }
}

