/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.model.MethodReference;
import org.teavm.runtime.Console;

public class ConsoleIntrinsic
implements WasmIntrinsic {
    private static final MethodReference PRINT_STRING = new MethodReference(WasmRuntime.class, "printString", String.class, Void.TYPE);
    private static final MethodReference PRINT_INT = new MethodReference(WasmRuntime.class, "printInt", Integer.TYPE, Void.TYPE);

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(Console.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "printString": 
            case "printInt": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "printString": {
                String name = manager.getNames().forMethod(PRINT_STRING);
                WasmCall call = new WasmCall(name, true);
                call.getArguments().add(manager.generate(invocation.getArguments().get(0)));
                return call;
            }
            case "printInt": {
                String name = manager.getNames().forMethod(PRINT_INT);
                WasmCall call = new WasmCall(name, true);
                call.getArguments().add(manager.generate(invocation.getArguments().get(0)));
                return call;
            }
        }
        return new WasmUnreachable();
    }
}

