/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.builder;

import java.util.Collection;
import java.util.List;
import org.teavm.callgraph.CallGraph;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.tooling.InstructionLocationReader;
import org.teavm.tooling.builder.BuildResult;
import org.teavm.vm.TeaVM;

public class SimpleBuildResult
implements BuildResult {
    private TeaVM vm;
    private List<String> generatedFiles;
    private Collection<String> usedResources;

    public SimpleBuildResult(TeaVM vm, List<String> generatedFiles) {
        this.vm = vm;
        this.generatedFiles = generatedFiles;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.vm.getDependencyInfo().getCallGraph();
    }

    @Override
    public ProblemProvider getProblems() {
        return this.vm.getProblemProvider();
    }

    @Override
    public Collection<String> getUsedResources() {
        if (this.usedResources == null) {
            this.usedResources = InstructionLocationReader.extractUsedResources(this.vm);
        }
        return this.usedResources;
    }

    @Override
    public Collection<String> getClasses() {
        return this.vm.getClasses();
    }

    @Override
    public Collection<String> getGeneratedFiles() {
        return this.generatedFiles;
    }
}

