/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.platform.plugin.ResourceAccessor;
import org.teavm.platform.plugin.ResourceAccessorGenerator;
import org.teavm.platform.plugin.ResourceAccessorInjector;
import org.teavm.vm.spi.TeaVMHost;

class ResourceAccessorTransformer
implements ClassHolderTransformer {
    private TeaVMJavaScriptHost jsHost;

    public ResourceAccessorTransformer(TeaVMHost vm) {
        this.jsHost = vm.getExtension(TeaVMJavaScriptHost.class);
    }

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (cls.getName().equals(ResourceAccessor.class.getName())) {
            ResourceAccessorInjector injector = new ResourceAccessorInjector();
            for (MethodHolder method : cls.getMethods()) {
                if (!method.hasModifier(ElementModifier.NATIVE)) continue;
                if (method.getName().equals("keys")) {
                    this.jsHost.add(method.getReference(), new ResourceAccessorGenerator());
                    continue;
                }
                this.jsHost.add(method.getReference(), injector);
            }
        }
    }
}

