/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.teavm.common.OptionalPredicate;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;

public class Devirtualization {
    private DependencyInfo dependency;
    private ClassHierarchy hierarchy;
    private Set<MethodReference> virtualMethods = new HashSet<MethodReference>();
    private Set<? extends MethodReference> readonlyVirtualMethods = Collections.unmodifiableSet(this.virtualMethods);

    public Devirtualization(DependencyInfo dependency, ClassHierarchy hierarchy) {
        this.dependency = dependency;
        this.hierarchy = hierarchy;
    }

    public void apply(MethodHolder method) {
        MethodDependencyInfo methodDep = this.dependency.getMethod(method.getReference());
        if (methodDep == null) {
            return;
        }
        Program program = method.getProgram();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                InvokeInstruction invoke;
                if (!(insn instanceof InvokeInstruction) || (invoke = (InvokeInstruction)insn).getType() != InvocationType.VIRTUAL) continue;
                ValueDependencyInfo var = methodDep.getVariable(invoke.getInstance().getIndex());
                Set<MethodReference> implementations = this.getImplementations(var.getTypes(), invoke.getMethod());
                if (implementations.size() == 1) {
                    invoke.setType(InvocationType.SPECIAL);
                    invoke.setMethod(implementations.iterator().next());
                    continue;
                }
                this.virtualMethods.addAll(implementations);
            }
        }
    }

    private Set<MethodReference> getImplementations(String[] classNames, MethodReference ref) {
        return Devirtualization.implementations(this.hierarchy, this.dependency, classNames, ref);
    }

    public static Set<MethodReference> implementations(ClassHierarchy hierarchy, DependencyInfo dependency, String[] classNames, MethodReference ref) {
        OptionalPredicate<String> isSuperclass = hierarchy.getSuperclassPredicate(ref.getClassName());
        LinkedHashSet<MethodReference> methods = new LinkedHashSet<MethodReference>();
        for (String className : classNames) {
            MethodDependencyInfo methodDep;
            ClassReader cls;
            if (className.startsWith("[")) {
                className = "java.lang.Object";
            }
            if ((cls = hierarchy.getClassSource().get(className)) == null || !isSuperclass.test(cls.getName(), false) || (methodDep = dependency.getMethodImplementation(new MethodReference(className, ref.getDescriptor()))) == null) continue;
            methods.add(methodDep.getReference());
        }
        return methods;
    }

    public Set<? extends MethodReference> getVirtualMethods() {
        return this.readonlyVirtualMethods;
    }
}

