/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.impl.MetaprogrammingImpl;
import org.teavm.metaprogramming.impl.reflect.ReflectAnnotatedElementImpl;
import org.teavm.metaprogramming.impl.reflect.ReflectContext;
import org.teavm.metaprogramming.impl.reflect.ReflectFieldImpl;
import org.teavm.metaprogramming.impl.reflect.ReflectMethodImpl;
import org.teavm.metaprogramming.reflect.ReflectField;
import org.teavm.metaprogramming.reflect.ReflectMethod;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;

public class ReflectClassImpl<T>
implements ReflectClass<T> {
    public final ValueType type;
    private ReflectContext context;
    public ClassReader classReader;
    private boolean resolved;
    private Class<?> cls;
    private Map<String, ReflectFieldImpl> declaredFields = new HashMap<String, ReflectFieldImpl>();
    private ReflectField[] fieldsCache;
    private Map<MethodDescriptor, ReflectMethodImpl> methods = new HashMap<MethodDescriptor, ReflectMethodImpl>();
    private Map<String, ReflectMethodImpl> declaredMethods = new HashMap<String, ReflectMethodImpl>();
    private ReflectMethod[] methodsCache;
    private ReflectAnnotatedElementImpl annotations;

    ReflectClassImpl(ValueType type, ReflectContext context) {
        this.type = type;
        this.context = context;
    }

    ReflectContext getReflectContext() {
        return this.context;
    }

    @Override
    public boolean isPrimitive() {
        return this.type instanceof ValueType.Primitive || this.type == ValueType.VOID;
    }

    @Override
    public boolean isInterface() {
        this.resolve();
        return this.classReader != null && this.classReader.readModifiers().contains((Object)ElementModifier.INTERFACE);
    }

    @Override
    public boolean isArray() {
        return this.type instanceof ValueType.Array;
    }

    @Override
    public boolean isAnnotation() {
        this.resolve();
        return this.classReader != null && this.classReader.readModifiers().contains((Object)ElementModifier.ANNOTATION);
    }

    @Override
    public boolean isEnum() {
        this.resolve();
        return this.classReader != null && this.classReader.readModifiers().contains((Object)ElementModifier.ENUM);
    }

    @Override
    public T[] getEnumConstants() {
        this.resolve();
        if (this.classReader == null) {
            return null;
        }
        if (this.cls == null) {
            try {
                this.cls = Class.forName(this.classReader.getName(), true, this.context.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return this.cls.getEnumConstants();
    }

    @Override
    public int getModifiers() {
        this.resolve();
        if (this.classReader == null) {
            return 0;
        }
        return ReflectContext.getModifiers(this.classReader);
    }

    @Override
    public ReflectClass<?> getComponentType() {
        if (!(this.type instanceof ValueType.Array)) {
            return null;
        }
        ValueType componentType = ((ValueType.Array)this.type).getItemType();
        return this.context.getClass(componentType);
    }

    @Override
    public String getName() {
        if (this.type instanceof ValueType.Object) {
            return ((ValueType.Object)this.type).getClassName();
        }
        if (this.type instanceof ValueType.Void) {
            return "void";
        }
        if (this.type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)this.type).getKind()) {
                case BOOLEAN: {
                    return "boolean";
                }
                case BYTE: {
                    return "byte";
                }
                case SHORT: {
                    return "short";
                }
                case CHARACTER: {
                    return "char";
                }
                case INTEGER: {
                    return "int";
                }
                case LONG: {
                    return "long";
                }
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
            }
            return "";
        }
        if (this.type instanceof ValueType.Array) {
            return this.type.toString().replace('/', '.');
        }
        return "";
    }

    @Override
    public ReflectClass<? super T> getSuperclass() {
        this.resolve();
        if (this.classReader == null || this.classReader.getParent() == null || this.classReader.getName().equals(this.classReader.getParent())) {
            return null;
        }
        return this.context.getClass(new ValueType.Object(this.classReader.getParent()));
    }

    @Override
    public ReflectClass<? super T>[] getInterfaces() {
        this.resolve();
        if (this.classReader == null) {
            return (ReflectClass[])Array.newInstance(ReflectClassImpl.class, 0);
        }
        return (ReflectClass[])this.classReader.getInterfaces().stream().map(iface -> this.context.getClass(new ValueType.Object((String)iface))).toArray(sz -> (ReflectClass[])Array.newInstance(ReflectClassImpl.class, sz));
    }

    @Override
    public boolean isInstance(Object obj) {
        throw new IllegalStateException("Don't call this method from compile domain");
    }

    @Override
    public T cast(Object obj) {
        throw new IllegalStateException("Don't call this method from compile domain");
    }

    @Override
    public <U> ReflectClass<U> asSubclass(Class<U> cls) {
        ReflectClassImpl<U> reflectClass = this.context.findClass(cls);
        if (!reflectClass.isAssignableFrom(this)) {
            throw new IllegalArgumentException(cls.getName() + " is not subclass of " + this.getName());
        }
        return this;
    }

    @Override
    public boolean isAssignableFrom(ReflectClass<?> cls) {
        return cls == this || cls.getSuperclass() != null && this.isAssignableFrom(cls.getSuperclass()) || Arrays.stream(cls.getInterfaces()).anyMatch(this::isAssignableFrom);
    }

    @Override
    public boolean isAssignableFrom(Class<?> cls) {
        return this.isAssignableFrom(MetaprogrammingImpl.findClass(cls));
    }

    @Override
    public ReflectMethod[] getDeclaredMethods() {
        this.resolve();
        if (this.classReader == null) {
            return new ReflectMethod[0];
        }
        return (ReflectMethod[])this.classReader.getMethods().stream().filter(method -> !method.getName().equals("<clinit>")).map(method -> this.getDeclaredMethod(method.getDescriptor())).toArray(ReflectMethod[]::new);
    }

    @Override
    public ReflectMethod[] getMethods() {
        this.resolve();
        if (this.classReader == null) {
            return new ReflectMethod[0];
        }
        if (this.methodsCache == null) {
            HashSet visited = new HashSet();
            this.methodsCache = (ReflectMethod[])this.context.getClassSource().getAncestors(this.classReader.getName()).flatMap(cls -> cls.getMethods().stream()).filter(method -> !method.getName().equals("<clinit>")).filter(method -> visited.add(method.getDescriptor().toString())).map(method -> super.getDeclaredMethod(method.getDescriptor())).filter(Objects::nonNull).toArray(ReflectMethod[]::new);
        }
        return (ReflectMethod[])this.methodsCache.clone();
    }

    @Override
    public ReflectMethod getDeclaredMethod(String name, ReflectClass<?> ... parameterTypes) {
        this.resolve();
        if (this.classReader == null) {
            return null;
        }
        ValueType[] internalParameterTypes = (ValueType[])Arrays.stream(parameterTypes).map(type -> ((ReflectClassImpl)type).type).toArray(ValueType[]::new);
        String key = name + "(" + ValueType.manyToString(internalParameterTypes) + ")";
        return this.declaredMethods.computeIfAbsent(key, k -> {
            MethodReader candidate = null;
            for (MethodReader methodReader : this.classReader.getMethods()) {
                if (!methodReader.getName().equals(name) || !Arrays.equals(methodReader.getParameterTypes(), internalParameterTypes)) continue;
                if (candidate == null) {
                    candidate = methodReader;
                    continue;
                }
                boolean moreSpecial = this.context.getHierarchy().isSuperType(candidate.getResultType(), methodReader.getResultType(), false);
                if (!moreSpecial) continue;
                candidate = methodReader;
            }
            return candidate != null ? this.getDeclaredMethod(candidate.getDescriptor()) : null;
        });
    }

    private ReflectMethodImpl getDeclaredMethod(MethodDescriptor method) {
        this.resolve();
        return this.methods.computeIfAbsent(method, m -> {
            MethodReader methodReader = this.classReader.getMethod((MethodDescriptor)m);
            return methodReader != null ? new ReflectMethodImpl(this, methodReader) : null;
        });
    }

    @Override
    public ReflectMethod getDeclaredJMethod(String name, Class<?> ... parameterTypes) {
        ReflectClass[] mappedParamTypes = (ReflectClass[])Arrays.stream(parameterTypes).map(MetaprogrammingImpl::findClass).toArray(ReflectClass[]::new);
        return this.getDeclaredMethod(name, mappedParamTypes);
    }

    @Override
    public ReflectMethod getJMethod(String name, Class<?> ... parameterTypes) {
        ReflectClass[] mappedParamTypes = (ReflectClass[])Arrays.stream(parameterTypes).map(MetaprogrammingImpl::findClass).toArray(ReflectClass[]::new);
        return this.getMethod(name, mappedParamTypes);
    }

    @Override
    public ReflectMethod getMethod(String name, ReflectClass<?> ... parameterTypes) {
        this.resolve();
        if (this.classReader == null) {
            return null;
        }
        Iterable ancestors = () -> this.context.getClassSource().getAncestors(this.classReader.getName()).iterator();
        for (ClassReader cls : ancestors) {
            ReflectClassImpl<?> reflectClass = this.context.getClass(ValueType.object(cls.getName()));
            ReflectMethod method = reflectClass.getDeclaredMethod(name, parameterTypes);
            if (method == null || !Modifier.isPublic(method.getModifiers())) continue;
            return method;
        }
        return null;
    }

    @Override
    public ReflectField[] getDeclaredFields() {
        this.resolve();
        if (this.classReader == null) {
            return new ReflectField[0];
        }
        return (ReflectField[])this.classReader.getFields().stream().map(fld -> this.getDeclaredField(fld.getName())).toArray(ReflectField[]::new);
    }

    @Override
    public ReflectField[] getFields() {
        if (this.fieldsCache == null) {
            this.resolve();
            if (this.classReader == null) {
                this.fieldsCache = new ReflectField[0];
            } else {
                HashSet visited = new HashSet();
                this.fieldsCache = (ReflectField[])this.context.getClassSource().getAncestors(this.classReader.getName()).flatMap(cls -> cls.getFields().stream().filter(fld -> fld.getLevel() == AccessLevel.PUBLIC)).filter(fld -> visited.add(fld.getName())).map(fld -> this.context.getClass(ValueType.object(fld.getOwnerName())).getDeclaredField(fld.getName())).toArray(ReflectField[]::new);
            }
        }
        return (ReflectField[])this.fieldsCache.clone();
    }

    @Override
    public ReflectField getDeclaredField(String name) {
        this.resolve();
        return this.declaredFields.computeIfAbsent(name, n -> {
            FieldReader fld = this.classReader.getField((String)n);
            return fld != null ? new ReflectFieldImpl(this, fld) : null;
        });
    }

    @Override
    public ReflectField getField(String name) {
        this.resolve();
        if (this.classReader == null) {
            return null;
        }
        FieldReader fieldReader = this.classReader.getField(name);
        return fieldReader != null && fieldReader.getLevel() == AccessLevel.PUBLIC ? this.getDeclaredField(name) : null;
    }

    public <S extends Annotation> S getAnnotation(Class<S> type) {
        this.resolve();
        if (this.classReader == null) {
            return null;
        }
        if (this.annotations == null) {
            this.annotations = new ReflectAnnotatedElementImpl(this.context, this.classReader.getAnnotations());
        }
        return this.annotations.getAnnotation(type);
    }

    public void resolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        if (!(this.type instanceof ValueType.Object)) {
            return;
        }
        String className = ((ValueType.Object)this.type).getClassName();
        this.classReader = this.context.getClassSource().get(className);
    }

    public String toString() {
        if (this.isArray()) {
            return this.getComponentType().toString() + "[]";
        }
        return this.getName();
    }

    @Override
    public T[] createArray(int size) {
        throw new IllegalStateException("Don't call this method from compile domain");
    }

    @Override
    public T getArrayElement(Object array, int index) {
        throw new IllegalStateException("Don't call this method from compile domain");
    }

    @Override
    public int getArrayLength(Object array) {
        throw new IllegalStateException("Don't call this method from compile domain");
    }

    @Override
    public Class<T> asJavaClass() {
        throw new IllegalStateException("Don't call this method from compile domain");
    }
}

