/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.devserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.teavm.apachecommons.io.IOUtils;
import org.teavm.backend.javascript.JavaScriptTarget;
import org.teavm.cache.InMemoryMethodNodeCache;
import org.teavm.cache.InMemoryProgramCache;
import org.teavm.cache.InMemorySymbolTable;
import org.teavm.cache.MemoryCachedClassReaderSource;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationBuilder;
import org.teavm.dependency.FastDependencyAnalyzer;
import org.teavm.devserver.CodeWsEndpoint;
import org.teavm.devserver.DevServerListener;
import org.teavm.devserver.HeaderConsumer;
import org.teavm.devserver.ProgressHandler;
import org.teavm.devserver.ProxyWsClient;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.parsing.ClasspathResourceMapper;
import org.teavm.parsing.resource.ClasspathResourceReader;
import org.teavm.parsing.resource.ResourceClassHolderMapper;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.builder.SimpleBuildResult;
import org.teavm.tooling.util.FileSystemWatcher;
import org.teavm.vm.MemoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;

public class CodeServlet
extends HttpServlet {
    private static final Supplier<InputStream> EMPTY_CONTENT = () -> null;
    private WebSocketServletFactory wsFactory;
    private String mainClass;
    private String[] classPath;
    private String fileName = "classes.js";
    private String pathToFile = "/";
    private String indicatorWsPath;
    private String deobfuscatorPath;
    private List<String> sourcePath = new ArrayList<String>();
    private TeaVMToolLog log = new EmptyTeaVMToolLog();
    private boolean indicator;
    private boolean deobfuscateStack;
    private boolean automaticallyReloaded;
    private int port;
    private int debugPort;
    private String proxyUrl;
    private String proxyPath = "/";
    private String proxyHost;
    private String proxyProtocol;
    private int proxyPort;
    private String proxyBaseUrl;
    private Map<String, Supplier<InputStream>> sourceFileCache = new HashMap<String, Supplier<InputStream>>();
    private volatile boolean stopped;
    private FileSystemWatcher watcher;
    private MemoryCachedClassReaderSource classSource;
    private InMemoryProgramCache programCache;
    private InMemoryMethodNodeCache astCache;
    private int lastReachedClasses;
    private boolean firstTime = true;
    private final Object contentLock = new Object();
    private final Map<String, byte[]> content = new HashMap<String, byte[]>();
    private MemoryBuildTarget buildTarget = new MemoryBuildTarget();
    private final Set<ProgressHandler> progressHandlers = new LinkedHashSet<ProgressHandler>();
    private final Object statusLock = new Object();
    private volatile boolean cancelRequested;
    private boolean compiling;
    private double progress;
    private boolean waiting;
    private Thread buildThread;
    private List<DevServerListener> listeners = new ArrayList<DevServerListener>();
    private HttpClient httpClient;
    private WebSocketClient wsClient = new WebSocketClient();
    private InMemorySymbolTable symbolTable = new InMemorySymbolTable();
    private InMemorySymbolTable fileSymbolTable = new InMemorySymbolTable();
    private InMemorySymbolTable variableSymbolTable = new InMemorySymbolTable();
    private ReferenceCache referenceCache = new ReferenceCache();
    private final ProgressListenerImpl progressListener = new ProgressListenerImpl();

    public CodeServlet(String mainClass, String[] classPath) {
        this.mainClass = mainClass;
        this.classPath = classPath != null ? (String[])classPath.clone() : new String[]{};
        this.httpClient = new HttpClient();
        this.httpClient.setFollowRedirects(false);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setPathToFile(String pathToFile) {
        this.pathToFile = CodeServlet.normalizePath(pathToFile);
    }

    public List<String> getSourcePath() {
        return this.sourcePath;
    }

    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    public void setIndicator(boolean indicator) {
        this.indicator = indicator;
    }

    public void setDeobfuscateStack(boolean deobfuscateStack) {
        this.deobfuscateStack = deobfuscateStack;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public void setAutomaticallyReloaded(boolean automaticallyReloaded) {
        this.automaticallyReloaded = automaticallyReloaded;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public void setProxyPath(String proxyPath) {
        this.proxyPath = CodeServlet.normalizePath(proxyPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressHandler(ProgressHandler handler) {
        double progress;
        Set<ProgressHandler> set = this.progressHandlers;
        synchronized (set) {
            this.progressHandlers.add(handler);
        }
        Object object = this.statusLock;
        synchronized (object) {
            if (!this.compiling) {
                return;
            }
            progress = this.progress;
        }
        handler.progress(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressHandler(ProgressHandler handler) {
        Set<ProgressHandler> set = this.progressHandlers;
        synchronized (set) {
            this.progressHandlers.remove(handler);
        }
    }

    public void addListener(DevServerListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.compiling) {
                return;
            }
            this.astCache.invalidate();
            this.programCache.invalidate();
            this.classSource.invalidate();
            this.symbolTable.invalidate();
            this.fileSymbolTable.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildProject() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.waiting) {
                this.buildThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBuild() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.compiling) {
                this.cancelRequested = true;
            }
        }
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.proxyUrl != null) {
            try {
                this.httpClient.start();
                this.wsClient.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                URL url = new URL(this.proxyUrl);
                this.proxyPort = url.getPort();
                this.proxyHost = this.proxyPort >= 0 ? url.getHost() + ":" + this.proxyPort : url.getHost();
                this.proxyProtocol = url.getProtocol();
                StringBuilder sb = new StringBuilder();
                sb.append(this.proxyProtocol).append("://").append(this.proxyHost);
                this.proxyBaseUrl = sb.toString();
            }
            catch (MalformedURLException e) {
                this.log.warning("Could not extract host from URL: " + this.proxyUrl, e);
            }
        }
        this.indicatorWsPath = this.pathToFile + this.fileName + ".ws";
        this.deobfuscatorPath = this.pathToFile + this.fileName + ".deobfuscator.js";
        WebSocketPolicy wsPolicy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        this.wsFactory = WebSocketServletFactory.Loader.load(config.getServletContext(), wsPolicy);
        this.wsFactory.setCreator((req, resp) -> {
            ProxyWsClient proxyClient = (ProxyWsClient)req.getHttpServletRequest().getAttribute("teavm.ws.client");
            if (proxyClient == null) {
                return new CodeWsEndpoint(this);
            }
            ProxyWsClient proxy = new ProxyWsClient();
            proxy.setTarget(proxyClient);
            proxyClient.setTarget(proxy);
            return proxy;
        });
        try {
            this.wsFactory.start();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getRequestURI();
        if (path != null) {
            this.log.debug("Serving " + path);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (req.getMethod().equals("GET") && path.startsWith(this.pathToFile) && path.length() > this.pathToFile.length()) {
                String fileName = path.substring(this.pathToFile.length());
                if (fileName.startsWith("src/")) {
                    if (this.serveSourceFile(fileName.substring("src/".length()), resp)) {
                        this.log.debug("File " + path + " served as source file");
                        return;
                    }
                } else if (path.equals(this.indicatorWsPath)) {
                    if (this.wsFactory.isUpgradeRequest(req, resp) && (this.wsFactory.acceptWebSocket(req, resp) || resp.isCommitted())) {
                        return;
                    }
                } else {
                    boolean firstTime;
                    byte[] fileContent;
                    if (path.equals(this.deobfuscatorPath)) {
                        this.serveDeobfuscator(resp);
                        return;
                    }
                    Object object = this.contentLock;
                    synchronized (object) {
                        fileContent = this.content.get(fileName);
                        firstTime = this.firstTime;
                    }
                    if (fileContent != null) {
                        resp.setStatus(200);
                        resp.setCharacterEncoding("UTF-8");
                        resp.setHeader("Access-Control-Allow-Origin", "*");
                        resp.setContentType("text/plain");
                        resp.getOutputStream().write(fileContent);
                        resp.getOutputStream().flush();
                        this.log.debug("File " + path + " served as generated file");
                        return;
                    }
                    if (fileName.equals(this.fileName) && this.indicator && firstTime) {
                        this.serveBootFile(resp);
                        return;
                    }
                }
            }
            if (this.proxyUrl != null && path.startsWith(this.proxyPath)) {
                if (this.wsFactory.isUpgradeRequest(req, resp)) {
                    this.proxyWebSocket(req, resp, path);
                } else {
                    this.proxy(req, resp, path);
                }
                return;
            }
        }
        this.log.debug("File " + path + " not found");
        resp.setStatus(404);
    }

    private void serveDeobfuscator(HttpServletResponse resp) throws IOException {
        ClassLoader loader = CodeServlet.class.getClassLoader();
        resp.setStatus(200);
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("text/plain");
        try (InputStream input = loader.getResourceAsStream("teavm/devserver/deobfuscator.js");){
            IOUtils.copy(input, (OutputStream)resp.getOutputStream());
        }
        resp.getOutputStream().flush();
    }

    private void proxy(HttpServletRequest req, HttpServletResponse resp, String path) throws IOException {
        AsyncContext async = req.startAsync();
        String relPath = path.substring(this.proxyPath.length());
        StringBuilder sb = new StringBuilder(this.proxyUrl);
        if (!relPath.isEmpty() && !this.proxyUrl.endsWith("/")) {
            sb.append("/");
        }
        sb.append(relPath);
        if (req.getQueryString() != null) {
            sb.append("?").append(req.getQueryString());
        }
        this.log.debug("Trying to serve '" + relPath + "' from '" + sb + "'");
        Request proxyReq = this.httpClient.newRequest(sb.toString());
        proxyReq.method(req.getMethod());
        this.copyRequestHeaders(req, proxyReq::header);
        proxyReq.content(new InputStreamContentProvider(req.getInputStream()));
        HeaderSender headerSender = new HeaderSender(resp);
        proxyReq.onResponseContent((response, responseContent) -> {
            headerSender.send(response);
            try {
                WritableByteChannel channel = Channels.newChannel(resp.getOutputStream());
                while (responseContent.remaining() > 0) {
                    channel.write(responseContent);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        proxyReq.send(result -> {
            headerSender.send(result.getResponse());
            async.complete();
        });
    }

    private void proxyWebSocket(final HttpServletRequest req, final HttpServletResponse resp, String path) throws IOException {
        URI uri;
        final AsyncContext async = req.startAsync();
        String relPath = path.substring(this.proxyPath.length());
        StringBuilder sb = new StringBuilder(this.proxyProtocol.equals("http") ? "ws" : "wss").append("://");
        sb.append(this.proxyHost);
        if (!relPath.isEmpty()) {
            sb.append("/");
        }
        sb.append(relPath);
        if (req.getQueryString() != null) {
            sb.append("?").append(req.getQueryString());
        }
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ProxyWsClient client = new ProxyWsClient();
        req.setAttribute("teavm.ws.client", client);
        ClientUpgradeRequest proxyReq = new ClientUpgradeRequest();
        proxyReq.setMethod(req.getMethod());
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        this.copyRequestHeaders(req, (key, value) -> headers.computeIfAbsent(key, k -> new ArrayList()).add(value));
        proxyReq.setHeaders(headers);
        this.wsClient.connect(client, uri, proxyReq, new UpgradeListener(){

            @Override
            public void onHandshakeRequest(UpgradeRequest request) {
            }

            @Override
            public void onHandshakeResponse(UpgradeResponse response) {
                resp.setStatus(response.getStatusCode());
                block11: for (String header : response.getHeaderNames()) {
                    switch (header.toLowerCase()) {
                        case "connection": 
                        case "date": 
                        case "sec-websocket-accept": 
                        case "upgrade": {
                            continue block11;
                        }
                    }
                    for (String value : response.getHeaders(header)) {
                        resp.addHeader(header, value);
                    }
                }
                try {
                    CodeServlet.this.wsFactory.acceptWebSocket(req, resp);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                async.complete();
            }
        });
    }

    private void copyRequestHeaders(HttpServletRequest req, HeaderConsumer proxyReq) {
        Enumeration<String> headers = req.getHeaderNames();
        block18: while (headers.hasMoreElements()) {
            String headerLower;
            String header = headers.nextElement();
            switch (headerLower = header.toLowerCase()) {
                case "host": {
                    if (this.proxyHost == null) break;
                    proxyReq.header(header, this.proxyHost);
                    continue block18;
                }
                case "origin": {
                    String origin;
                    if (this.proxyBaseUrl == null || !(origin = req.getHeader(header)).equals("http://localhost:" + this.port)) break;
                    proxyReq.header(header, this.proxyBaseUrl);
                    continue block18;
                }
                case "referer": {
                    String referer = req.getHeader(header);
                    String localUrl = "http://localhost:" + this.port + "/";
                    if (!referer.startsWith(localUrl)) break;
                    String relReferer = referer.substring(localUrl.length());
                    proxyReq.header(header, this.proxyUrl + relReferer);
                    continue block18;
                }
                case "connection": 
                case "upgrade": 
                case "user-agent": 
                case "sec-websocket-key": 
                case "sec-websocket-version": 
                case "sec-websocket-extensions": 
                case "accept-encoding": {
                    continue block18;
                }
            }
            Enumeration<String> values = req.getHeaders(header);
            while (values.hasMoreElements()) {
                proxyReq.header(header, values.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        super.destroy();
        try {
            this.wsFactory.stop();
        }
        catch (Exception e) {
            this.log.warning("Error stopping WebSocket server", e);
        }
        if (this.proxyUrl != null) {
            try {
                this.httpClient.stop();
            }
            catch (Exception e) {
                this.log.warning("Error stopping HTTP client", e);
            }
            try {
                this.wsClient.stop();
            }
            catch (Exception e) {
                this.log.warning("Error stopping WebSocket client", e);
            }
        }
        this.stopped = true;
        Object object = this.statusLock;
        synchronized (object) {
            if (this.waiting) {
                this.buildThread.interrupt();
            }
        }
    }

    @Override
    public void init() throws ServletException {
        super.init();
        Thread thread = new Thread(this::runTeaVM);
        thread.setName("TeaVM compiler");
        thread.start();
        this.buildThread = thread;
    }

    private boolean serveSourceFile(String fileName, HttpServletResponse resp) throws IOException {
        try (InputStream stream = (InputStream)this.sourceFileCache.computeIfAbsent(fileName, this::findSourceFile).get();){
            if (stream == null) {
                boolean bl = false;
                return bl;
            }
            resp.setStatus(200);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/plain");
            IOUtils.copy(stream, (OutputStream)resp.getOutputStream());
            resp.getOutputStream().flush();
            boolean bl = true;
            return bl;
        }
    }

    private Supplier<InputStream> findSourceFile(String fileName) {
        for (String element : this.sourcePath) {
            Supplier<InputStream> result;
            File sourceFile = new File(element);
            if (sourceFile.isFile()) {
                result = this.findSourceFileInZip(sourceFile, fileName);
                if (result == null) continue;
                return result;
            }
            if (!sourceFile.isDirectory() || !((File)((Object)(result = new File(sourceFile, fileName)))).exists()) continue;
            return () -> CodeServlet.lambda$findSourceFile$6((File)((Object)result));
        }
        return EMPTY_CONTENT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Supplier<InputStream> findSourceFileInZip(File zipFile, String fileName) {
        try (ZipFile zip = new ZipFile(zipFile);){
            ZipEntry entry = zip.getEntry(fileName);
            if (entry == null) {
                Supplier<InputStream> supplier2 = null;
                return supplier2;
            }
            Supplier<InputStream> supplier = () -> {
                try {
                    ZipEntry e;
                    ZipInputStream input = new ZipInputStream(new FileInputStream(zipFile));
                    do {
                        if ((e = input.getNextEntry()) != null) continue;
                        return null;
                    } while (!e.getName().equals(fileName));
                    return input;
                }
                catch (IOException e) {
                    return null;
                }
            };
            return supplier;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void serveBootFile(HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("text/plain");
        resp.getWriter().write("function main() { }\n");
        resp.getWriter().write(this.getIndicatorScript(true));
        resp.getWriter().flush();
        this.log.debug("Served boot file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTeaVM() {
        try {
            this.initBuilder();
            while (!this.stopped) {
                this.buildOnce();
                if (this.stopped) break;
                try {
                    Object object = this.statusLock;
                    synchronized (object) {
                        this.waiting = true;
                    }
                    this.watcher.waitForChange(750);
                    object = this.statusLock;
                    synchronized (object) {
                        this.waiting = false;
                    }
                    this.log.info("Changes detected. Recompiling.");
                }
                catch (InterruptedException e) {
                    if (this.stopped) break;
                    this.log.info("Build triggered by user");
                }
                List<String> staleClasses = this.getChangedClasses(this.watcher.grabChangedFiles());
                if (staleClasses.size() > 15) {
                    List<String> displayedStaleClasses = staleClasses.subList(0, 10);
                    this.log.debug("Following classes changed (" + staleClasses.size() + "): " + String.join((CharSequence)", ", displayedStaleClasses) + " and more...");
                } else {
                    this.log.debug("Following classes changed (" + staleClasses.size() + "): " + String.join((CharSequence)", ", staleClasses));
                }
                this.classSource.evict(staleClasses);
            }
            this.log.info("Build process stopped");
        }
        catch (Throwable e) {
            this.log.error("Compile server crashed", e);
        }
        finally {
            this.shutdownBuilder();
        }
    }

    private void initBuilder() throws IOException {
        this.watcher = new FileSystemWatcher(this.classPath);
        this.classSource = this.createCachedSource();
        this.astCache = new InMemoryMethodNodeCache(this.referenceCache, this.symbolTable, this.fileSymbolTable, this.variableSymbolTable);
        this.programCache = new InMemoryProgramCache(this.referenceCache, this.symbolTable, this.fileSymbolTable, this.variableSymbolTable);
    }

    private MemoryCachedClassReaderSource createCachedSource() {
        return new MemoryCachedClassReaderSource(this.referenceCache, this.symbolTable, this.fileSymbolTable, this.variableSymbolTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownBuilder() {
        try {
            this.watcher.dispose();
        }
        catch (IOException e) {
            this.log.debug("Exception caught", e);
        }
        this.classSource = null;
        this.watcher = null;
        this.astCache = null;
        this.programCache = null;
        Map<String, byte[]> map = this.content;
        synchronized (map) {
            this.content.clear();
        }
        this.buildTarget.clear();
        this.log.info("Build thread complete");
    }

    private void buildOnce() {
        this.fireBuildStarted();
        this.reportProgress(0.0);
        DebugInformationBuilder debugInformationBuilder = new DebugInformationBuilder(this.referenceCache);
        ClassLoader classLoader = this.initClassLoader();
        ClasspathResourceReader reader = new ClasspathResourceReader(classLoader);
        ResourceClassHolderMapper rawMapper = new ResourceClassHolderMapper(reader, this.referenceCache);
        ClasspathResourceMapper classPathMapper = new ClasspathResourceMapper(classLoader, this.referenceCache, (Function<String, ClassHolder>)rawMapper);
        this.classSource.setProvider(name -> PreOptimizingClassHolderSource.optimize(classPathMapper, name));
        long startTime = System.currentTimeMillis();
        JavaScriptTarget jsTarget = new JavaScriptTarget();
        TeaVM vm = new TeaVMBuilder(jsTarget).setReferenceCache(this.referenceCache).setClassLoader(classLoader).setClassSource(this.classSource).setDependencyAnalyzerFactory(FastDependencyAnalyzer::new).setClassSourcePacker(this::packClasses).build();
        jsTarget.setStackTraceIncluded(true);
        jsTarget.setMinifying(false);
        jsTarget.setAstCache(this.astCache);
        jsTarget.setDebugEmitter(debugInformationBuilder);
        jsTarget.setTopLevelNameLimit(500);
        vm.setOptimizationLevel(TeaVMOptimizationLevel.SIMPLE);
        vm.setCacheStatus(this.classSource);
        vm.addVirtualMethods(m -> true);
        vm.setProgressListener(this.progressListener);
        vm.setProgramCache(this.programCache);
        vm.installPlugins();
        vm.setLastKnownClasses(this.lastReachedClasses);
        vm.entryPoint(this.mainClass);
        this.log.info("Starting build");
        this.progressListener.last = 0;
        this.progressListener.lastTime = System.currentTimeMillis();
        vm.build(this.buildTarget, this.fileName);
        this.addIndicator();
        this.generateDebug(debugInformationBuilder);
        this.postBuild(vm, startTime);
    }

    private ClassReaderSource packClasses(ClassReaderSource source, Collection<? extends String> classNames) {
        MemoryCachedClassReaderSource packedSource = this.createCachedSource();
        packedSource.setProvider(source::get);
        for (String string : classNames) {
            packedSource.populate(string);
        }
        packedSource.setProvider(null);
        return packedSource;
    }

    private void addIndicator() {
        String script = this.getIndicatorScript(false);
        try (OutputStreamWriter writer = new OutputStreamWriter(this.buildTarget.appendToResource(this.fileName), StandardCharsets.UTF_8);){
            ((Writer)writer).append("\n");
            ((Writer)writer).append(script);
        }
        catch (IOException e) {
            throw new RuntimeException("IO error occurred writing debug information", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getIndicatorScript(boolean boot) {
        try (InputStreamReader reader = new InputStreamReader(CodeServlet.class.getResourceAsStream("indicator.js"), StandardCharsets.UTF_8);){
            String script = IOUtils.toString(reader);
            script = script.substring(script.indexOf("*/") + 2);
            script = script.replace("WS_PATH", "localhost:" + this.port + this.pathToFile + this.fileName + ".ws");
            script = script.replace("BOOT_FLAG", Boolean.toString(boot));
            script = script.replace("RELOAD_FLAG", Boolean.toString(this.automaticallyReloaded));
            script = script.replace("INDICATOR_FLAG", Boolean.toString(this.indicator));
            script = script.replace("DEBUG_PORT", Integer.toString(this.debugPort));
            script = script.replace("FILE_NAME", "\"" + this.fileName + "\"");
            script = script.replace("PATH_TO_FILE", "\"http://localhost:" + this.port + this.pathToFile + "\"");
            String string = script = script.replace("DEOBFUSCATE_FLAG", String.valueOf(this.deobfuscateStack));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("IO error occurred writing debug information", e);
        }
    }

    private void generateDebug(DebugInformationBuilder debugInformationBuilder) {
        try {
            DebugInformation debugInformation = debugInformationBuilder.getDebugInformation();
            String sourceMapName = this.fileName + ".map";
            try (OutputStreamWriter writer = new OutputStreamWriter(this.buildTarget.appendToResource(this.fileName), StandardCharsets.UTF_8);){
                ((Writer)writer).append("\n//# sourceMappingURL=" + sourceMapName);
            }
            writer = new OutputStreamWriter(this.buildTarget.createResource(sourceMapName), StandardCharsets.UTF_8);
            var5_6 = null;
            try {
                debugInformation.writeAsSourceMaps(writer, "src", this.fileName);
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var5_6 != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
            debugInformation.write(this.buildTarget.createResource(this.fileName + ".teavmdbg"));
        }
        catch (IOException e) {
            throw new RuntimeException("IO error occurred writing debug information", e);
        }
    }

    private void postBuild(TeaVM vm, long startTime) {
        if (!vm.wasCancelled()) {
            this.log.info("Recompiled stale methods: " + this.programCache.getPendingItemsCount());
            this.fireBuildComplete(vm);
            if (vm.getProblemProvider().getSevereProblems().isEmpty()) {
                this.log.info("Build complete successfully");
                this.saveNewResult();
                this.lastReachedClasses = vm.getDependencyInfo().getReachableClasses().size();
                this.classSource.commit();
                this.programCache.commit();
                this.astCache.commit();
                this.reportCompilationComplete(true);
            } else {
                this.log.info("Build complete with errors");
                this.reportCompilationComplete(false);
            }
            this.printStats(vm, startTime);
            TeaVMProblemRenderer.describeProblems(vm, this.log);
        } else {
            this.log.info("Build cancelled");
            this.fireBuildCancelled();
        }
        this.astCache.discard();
        this.programCache.discard();
        this.buildTarget.clear();
        this.cancelRequested = false;
    }

    private void printStats(TeaVM vm, long startTime) {
        if (vm.getWrittenClasses() != null) {
            int classCount = vm.getWrittenClasses().getClassNames().size();
            int methodCount = 0;
            for (String className : vm.getWrittenClasses().getClassNames()) {
                ClassReader cls = vm.getWrittenClasses().get(className);
                methodCount += cls.getMethods().size();
            }
            this.log.info("Classes compiled: " + classCount);
            this.log.info("Methods compiled: " + methodCount);
        }
        this.log.info("Compilation took " + (System.currentTimeMillis() - startTime) + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNewResult() {
        Object object = this.contentLock;
        synchronized (object) {
            this.firstTime = false;
            this.content.clear();
            for (String string : this.buildTarget.getNames()) {
                this.content.put(string, this.buildTarget.getContent(string));
            }
        }
    }

    private List<String> getChangedClasses(Collection<File> changedFiles) {
        ArrayList<String> result = new ArrayList<String>();
        String[] prefixes = (String[])Arrays.stream(this.classPath).map(s -> s.replace('\\', '/')).toArray(String[]::new);
        for (File file : changedFiles) {
            String path = file.getPath().replace('\\', '/');
            if (!path.endsWith(".class")) continue;
            String prefix = Arrays.stream(prefixes).filter(path::startsWith).findFirst().orElse("");
            int start = prefix.length();
            if (start < path.length() && path.charAt(start) == '/') {
                ++start;
            }
            path = path.substring(start, path.length() - ".class".length()).replace('/', '.');
            result.add(path);
        }
        return result;
    }

    private ClassLoader initClassLoader() {
        URL[] urls = new URL[this.classPath.length];
        try {
            for (int i = 0; i < this.classPath.length; ++i) {
                urls[i] = new File(this.classPath[i]).toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return new URLClassLoader(urls, CodeServlet.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportProgress(double progress) {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.compiling && this.progress == progress) {
                return;
            }
            this.compiling = true;
            this.progress = progress;
        }
        ProgressHandler[] progressHandlerArray = this.progressHandlers;
        synchronized (this.progressHandlers) {
            ProgressHandler[] handlers = this.progressHandlers.toArray(new ProgressHandler[0]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (ProgressHandler handler : handlers) {
                handler.progress(progress);
            }
            for (DevServerListener listener : this.listeners) {
                listener.compilationProgress(progress);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportCompilationComplete(boolean success) {
        Object object = this.statusLock;
        synchronized (object) {
            if (!this.compiling) {
                return;
            }
            this.compiling = false;
        }
        ProgressHandler[] progressHandlerArray = this.progressHandlers;
        synchronized (this.progressHandlers) {
            ProgressHandler[] handlers = this.progressHandlers.toArray(new ProgressHandler[0]);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            for (ProgressHandler handler : handlers) {
                handler.complete(success);
            }
            return;
        }
    }

    private void fireBuildStarted() {
        for (DevServerListener listener : this.listeners) {
            listener.compilationStarted();
        }
    }

    private void fireBuildCancelled() {
        for (DevServerListener listener : this.listeners) {
            listener.compilationCancelled();
        }
    }

    private void fireBuildComplete(TeaVM vm) {
        SimpleBuildResult result = new SimpleBuildResult(vm, new ArrayList<String>(this.buildTarget.getNames()));
        for (DevServerListener listener : this.listeners) {
            listener.compilationComplete(result);
        }
    }

    static String normalizePath(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private static /* synthetic */ InputStream lambda$findSourceFile$6(File result) {
        try {
            return new FileInputStream(result);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    class ProgressListenerImpl
    implements TeaVMProgressListener {
        private int start;
        private int end;
        private int phaseLimit;
        private int last;
        private long lastTime;

        ProgressListenerImpl() {
        }

        @Override
        public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int count) {
            switch (phase) {
                case DEPENDENCY_ANALYSIS: {
                    this.start = 0;
                    this.end = 500;
                    break;
                }
                case COMPILING: {
                    this.start = 500;
                    this.end = 1000;
                }
            }
            this.phaseLimit = count;
            return this.progressReached(0);
        }

        @Override
        public TeaVMProgressFeedback progressReached(int progress) {
            int current;
            if (CodeServlet.this.indicator && (current = this.start + Math.min(progress, this.phaseLimit) * (this.end - this.start) / this.phaseLimit) != this.last && (current - this.last > 10 || System.currentTimeMillis() - this.lastTime > 100L)) {
                this.lastTime = System.currentTimeMillis();
                this.last = current;
                CodeServlet.this.reportProgress((double)current / 10.0);
            }
            return this.getResult();
        }

        private TeaVMProgressFeedback getResult() {
            if (CodeServlet.this.cancelRequested) {
                CodeServlet.this.log.info("Trying to cancel compilation due to user request");
                return TeaVMProgressFeedback.CANCEL;
            }
            if (CodeServlet.this.stopped) {
                CodeServlet.this.log.info("Trying to cancel compilation due to server stopping");
                return TeaVMProgressFeedback.CANCEL;
            }
            try {
                if (CodeServlet.this.watcher.hasChanges()) {
                    CodeServlet.this.log.info("Changes detected, cancelling build");
                    return TeaVMProgressFeedback.CANCEL;
                }
            }
            catch (IOException e) {
                CodeServlet.this.log.info("IO error occurred", e);
                return TeaVMProgressFeedback.CANCEL;
            }
            return TeaVMProgressFeedback.CONTINUE;
        }
    }

    class HeaderSender {
        final HttpServletResponse resp;
        boolean sent;

        HeaderSender(HttpServletResponse resp) {
            this.resp = resp;
        }

        void send(Response response) {
            if (this.sent) {
                return;
            }
            this.sent = true;
            this.resp.setStatus(response.getStatus());
            for (HttpField field : response.getHeaders()) {
                String value;
                if (field.getName().toLowerCase().equals("location") && (value = field.getValue()).startsWith(CodeServlet.this.proxyUrl)) {
                    String relLocation = value.substring(CodeServlet.this.proxyUrl.length());
                    this.resp.addHeader(field.getName(), "http://localhost:" + CodeServlet.this.port + CodeServlet.this.proxyPath + relLocation);
                    continue;
                }
                this.resp.addHeader(field.getName(), field.getValue());
            }
        }
    }
}

