/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging.information;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationProvider;

public class URLDebugInformationProvider
implements DebugInformationProvider {
    private String baseURL;

    public URLDebugInformationProvider(String baseURL) {
        this.baseURL = baseURL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DebugInformation getDebugInformation(String script) {
        try {
            URL url = new URL(this.baseURL + script + ".teavmdbg");
            try (InputStream input = url.openStream();){
                DebugInformation debugInformation = DebugInformation.read(input);
                return debugInformation;
            }
        }
        catch (IOException e) {
            return null;
        }
    }
}

