/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteBufferImpl;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.classlib.java.nio.TShortBuffer;

public abstract class TByteBuffer
extends TBuffer
implements TComparable<TByteBuffer> {
    int start;
    byte[] array;
    TByteOrder order = TByteOrder.BIG_ENDIAN;

    TByteBuffer(int start, int capacity, byte[] array, int position, int limit) {
        super(capacity);
        this.start = start;
        this.array = array;
        this.position = position;
        this.limit = limit;
    }

    public static TByteBuffer allocateDirect(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        return new TByteBufferImpl(capacity, true);
    }

    public static TByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        return new TByteBufferImpl(capacity, false);
    }

    public static TByteBuffer wrap(byte[] array, int offset, int length) {
        return new TByteBufferImpl(0, array.length, array, offset, offset + length, false, false);
    }

    public static TByteBuffer wrap(byte[] array) {
        return TByteBuffer.wrap(array, 0, array.length);
    }

    public abstract TByteBuffer slice();

    public abstract TByteBuffer duplicate();

    public abstract TByteBuffer asReadOnlyBuffer();

    public abstract byte get();

    public abstract TByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract TByteBuffer put(int var1, byte var2);

    public TByteBuffer get(byte[] dst, int offset, int length) {
        if (offset < 0 || offset >= dst.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + dst.length + ")");
        }
        if (offset + length > dst.length) {
            throw new IndexOutOfBoundsException("The last byte in dst " + (offset + length) + " is outside of array of size " + dst.length);
        }
        if (this.remaining() < length) {
            throw new TBufferUnderflowException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position + this.start;
        for (int i = 0; i < length; ++i) {
            dst[offset++] = this.array[pos++];
        }
        this.position += length;
        return this;
    }

    public TByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TByteBuffer put(TByteBuffer src) {
        return this.put(src.array, src.start + src.position, src.remaining());
    }

    public TByteBuffer put(byte[] src, int offset, int length) {
        if (length == 0) {
            return this;
        }
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (offset < 0 || offset >= src.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + src.length + ")");
        }
        if (offset + length > src.length) {
            throw new IndexOutOfBoundsException("The last byte in src " + (offset + length) + " is outside of array of size " + src.length);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position + this.start;
        for (int i = 0; i < length; ++i) {
            this.array[pos++] = src[offset++];
        }
        this.position += length;
        return this;
    }

    public final TByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    public final byte[] array() {
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return this.start;
    }

    public abstract TByteBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[ByteBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity + ", mark " + (this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position + this.start;
        for (int i = this.position; i < this.limit; ++i) {
            hashCode = 31 * hashCode + this.array[pos++];
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TByteBuffer)) {
            return false;
        }
        TByteBuffer other = (TByteBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position + this.start;
        int b = other.position + other.start;
        for (int i = 0; i < sz; ++i) {
            if (this.array[a++] == other.array[b++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TByteBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position + this.start;
        int b = other.position + other.start;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Byte.compare(this.array[a++], other.array[b++])) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public final TByteOrder order() {
        return this.order;
    }

    public final TByteBuffer order(TByteOrder bo) {
        this.order = bo;
        return this;
    }

    public abstract char getChar();

    public abstract TByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract TByteBuffer putChar(int var1, char var2);

    public abstract TCharBuffer asCharBuffer();

    public abstract short getShort();

    public abstract TByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract TByteBuffer putShort(int var1, short var2);

    public abstract TShortBuffer asShortBuffer();

    public abstract int getInt();

    public abstract TByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract TByteBuffer putInt(int var1, int var2);

    public abstract TIntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract TByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract TByteBuffer putLong(int var1, long var2);

    public abstract TLongBuffer asLongBuffer();

    public abstract TFloatBuffer asFloatBuffer();

    public abstract TDoubleBuffer asDoubleBuffer();

    @Override
    public final TByteBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TByteBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TByteBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TByteBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TByteBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TByteBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TByteBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

