/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StringResource;

public class DateSymbolsMetadataGenerator
implements MetadataGenerator {
    @Override
    public Resource generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        switch (method.getName()) {
            case "getErasMap": {
                return this.generateSymbols(context, locale -> locale.getEras());
            }
            case "getAmPmMap": {
                return this.generateSymbols(context, locale -> locale.getDayPeriods());
            }
            case "getMonthMap": {
                return this.generateSymbols(context, locale -> locale.getMonths());
            }
            case "getShortMonthMap": {
                return this.generateSymbols(context, locale -> locale.getShortMonths());
            }
            case "getWeekdayMap": {
                return this.generateSymbols(context, locale -> locale.getWeekdays());
            }
            case "getShortWeekdayMap": {
                return this.generateSymbols(context, locale -> locale.getShortWeekdays());
            }
        }
        throw new AssertionError((Object)("Unsupported method: " + method));
    }

    private Resource generateSymbols(MetadataGeneratorContext context, ResourceExtractor extractor) {
        CLDRReader reader = context.getService(CLDRReader.class);
        ResourceMap result = context.createResourceMap();
        for (Map.Entry<String, CLDRLocale> localeEntry : reader.getKnownLocales().entrySet()) {
            ResourceArray<StringResource> symbolsRes = context.createResourceArray();
            result.put(localeEntry.getKey(), symbolsRes);
            for (String symbol : extractor.extract(localeEntry.getValue())) {
                StringResource symbolRes = context.createResource(StringResource.class);
                symbolRes.setValue(symbol);
                symbolsRes.add(symbolRes);
            }
        }
        return result;
    }

    private static interface ResourceExtractor {
        public String[] extract(CLDRLocale var1);
    }
}

