/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import java.util.ArrayList;
import java.util.List;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.model.MethodReference;
import org.teavm.runtime.GC;

public class GCIntrinsic
implements WasmIntrinsic {
    private static final MethodReference PRINT_OUT_OF_MEMORY = new MethodReference(WasmRuntime.class, "printOutOfMemory", Void.TYPE);
    private List<WasmInt32Constant> heapAddressExpressions = new ArrayList<WasmInt32Constant>();
    private List<WasmInt64Constant> availableBytesExpressions = new ArrayList<WasmInt64Constant>();
    private List<WasmInt32Constant> gcStorageAddressExpressions = new ArrayList<WasmInt32Constant>();
    private List<WasmInt32Constant> gcStorageSizeExpressions = new ArrayList<WasmInt32Constant>();
    private List<WasmInt32Constant> regionSizeExpressions = new ArrayList<WasmInt32Constant>();
    private List<WasmInt32Constant> regionsAddressExpressions = new ArrayList<WasmInt32Constant>();
    private List<WasmInt32Constant> regionMaxCountExpressions = new ArrayList<WasmInt32Constant>();

    public void setHeapAddress(int address) {
        for (WasmInt32Constant constant : this.heapAddressExpressions) {
            constant.setValue(address);
        }
    }

    public void setAvailableBytes(long availableBytes) {
        for (WasmInt64Constant constant : this.availableBytesExpressions) {
            constant.setValue(availableBytes);
        }
    }

    public void setGCStorageAddress(int address) {
        for (WasmInt32Constant constant : this.gcStorageAddressExpressions) {
            constant.setValue(address);
        }
    }

    public void setGCStorageSize(int storageSize) {
        for (WasmInt32Constant constant : this.gcStorageSizeExpressions) {
            constant.setValue(storageSize);
        }
    }

    public void setRegionSize(int regionSize) {
        for (WasmInt32Constant constant : this.regionSizeExpressions) {
            constant.setValue(regionSize);
        }
    }

    public void setRegionsAddress(int address) {
        for (WasmInt32Constant constant : this.regionsAddressExpressions) {
            constant.setValue(address);
        }
    }

    public void setRegionMaxCount(int maxCount) {
        for (WasmInt32Constant constant : this.regionMaxCountExpressions) {
            constant.setValue(maxCount);
        }
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().endsWith(GC.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "gcStorageAddress": 
            case "gcStorageSize": 
            case "heapAddress": 
            case "availableBytes": 
            case "regionsAddress": 
            case "regionMaxCount": 
            case "regionSize": 
            case "outOfMemory": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        List<WasmInt32Constant> list;
        switch (invocation.getMethod().getName()) {
            case "gcStorageAddress": {
                list = this.gcStorageAddressExpressions;
                break;
            }
            case "gcStorageSize": {
                list = this.gcStorageSizeExpressions;
                break;
            }
            case "heapAddress": {
                list = this.heapAddressExpressions;
                break;
            }
            case "regionsAddress": {
                list = this.regionsAddressExpressions;
                break;
            }
            case "regionMaxCount": {
                list = this.regionMaxCountExpressions;
                break;
            }
            case "regionSize": {
                list = this.regionSizeExpressions;
                break;
            }
            case "availableBytes": {
                WasmInt64Constant constant = new WasmInt64Constant(0L);
                this.availableBytesExpressions.add(constant);
                return constant;
            }
            case "outOfMemory": {
                WasmBlock block = new WasmBlock(false);
                WasmCall call = new WasmCall(manager.getNames().forMethod(PRINT_OUT_OF_MEMORY), true);
                block.getBody().add(call);
                block.getBody().add(new WasmUnreachable());
                return block;
            }
            default: {
                throw new IllegalArgumentException(invocation.getMethod().toString());
            }
        }
        WasmInt32Constant result = new WasmInt32Constant(0);
        list.add(result);
        return result;
    }
}

