/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.util.Set;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.AsyncMethodNode;
import org.teavm.ast.AsyncMethodPart;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.MethodNodeVisitor;
import org.teavm.ast.MonitorEnterStatement;
import org.teavm.ast.MonitorExitStatement;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.NewExpr;
import org.teavm.ast.NewMultiArrayExpr;
import org.teavm.ast.OperationType;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.RecursiveVisitor;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.UnaryExpr;
import org.teavm.backend.javascript.codegen.NameFrequencyConsumer;
import org.teavm.backend.javascript.decompile.PreparedClass;
import org.teavm.backend.javascript.decompile.PreparedMethod;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

class NameFrequencyEstimator
extends RecursiveVisitor
implements MethodNodeVisitor {
    static final MethodReference MONITOR_ENTER_METHOD = new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE);
    static final MethodReference MONITOR_ENTER_SYNC_METHOD = new MethodReference(Object.class, "monitorEnterSync", Object.class, Void.TYPE);
    static final MethodReference MONITOR_EXIT_METHOD = new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE);
    static final MethodReference MONITOR_EXIT_SYNC_METHOD = new MethodReference(Object.class, "monitorExitSync", Object.class, Void.TYPE);
    private static final MethodDescriptor CLINIT_METHOD = new MethodDescriptor("<clinit>", ValueType.VOID);
    private final NameFrequencyConsumer consumer;
    private final ClassReaderSource classSource;
    private boolean async;
    private final Set<MethodReference> injectedMethods;
    private final Set<MethodReference> asyncFamilyMethods;

    NameFrequencyEstimator(NameFrequencyConsumer consumer, ClassReaderSource classSource, Set<MethodReference> injectedMethods, Set<MethodReference> asyncFamilyMethods) {
        this.consumer = consumer;
        this.classSource = classSource;
        this.injectedMethods = injectedMethods;
        this.asyncFamilyMethods = asyncFamilyMethods;
    }

    public void estimate(PreparedClass cls) {
        this.consumer.consume(cls.getName());
        if (cls.getParentName() != null) {
            this.consumer.consume(cls.getParentName());
        }
        for (FieldHolder field : cls.getClassHolder().getFields()) {
            this.consumer.consume(new FieldReference(cls.getName(), field.getName()));
            if (!field.getModifiers().contains((Object)ElementModifier.STATIC)) continue;
            this.consumer.consume(cls.getName());
        }
        MethodReader clinit = this.classSource.get(cls.getName()).getMethod(CLINIT_METHOD);
        for (PreparedMethod method : cls.getMethods()) {
            this.consumer.consume(method.reference);
            if (this.asyncFamilyMethods.contains(method.reference)) {
                this.consumer.consume(method.reference);
            }
            if (clinit != null && (method.methodHolder.getModifiers().contains((Object)ElementModifier.STATIC) || method.reference.getName().equals("<init>"))) {
                this.consumer.consume(method.reference);
            }
            if (!method.methodHolder.getModifiers().contains((Object)ElementModifier.STATIC)) {
                this.consumer.consume(method.reference.getDescriptor());
                this.consumer.consume(method.reference);
            }
            if (method.async) {
                this.consumer.consumeFunction("$rt_nativeThread");
                this.consumer.consumeFunction("$rt_nativeThread");
                this.consumer.consumeFunction("$rt_resuming");
                this.consumer.consumeFunction("$rt_invalidPointer");
            }
            if (method.node == null) continue;
            method.node.acceptVisitor(this);
        }
        if (clinit != null) {
            this.consumer.consumeFunction("$rt_eraseClinit");
        }
        this.consumer.consume(cls.getName());
        this.consumer.consume(cls.getName());
        if (cls.getParentName() != null) {
            this.consumer.consume(cls.getParentName());
        }
        for (String iface : cls.getClassHolder().getInterfaces()) {
            this.consumer.consume(iface);
        }
    }

    @Override
    public void visit(RegularMethodNode methodNode) {
        this.async = false;
        methodNode.getBody().acceptVisitor(this);
    }

    @Override
    public void visit(AsyncMethodNode methodNode) {
        this.async = true;
        for (AsyncMethodPart part : methodNode.getBody()) {
            part.getStatement().acceptVisitor(this);
        }
    }

    @Override
    public void visit(AssignmentStatement statement) {
        super.visit(statement);
        if (statement.isAsync()) {
            this.consumer.consumeFunction("$rt_suspending");
        }
    }

    @Override
    public void visit(ThrowStatement statement) {
        statement.getException().acceptVisitor(this);
        this.consumer.consumeFunction("$rt_throw");
    }

    @Override
    public void visit(InitClassStatement statement) {
        this.consumer.consumeClassInit(statement.getClassName());
    }

    @Override
    public void visit(TryCatchStatement statement) {
        super.visit(statement);
        if (statement.getExceptionType() != null) {
            this.consumer.consume(statement.getExceptionType());
        }
        this.consumer.consumeFunction("$rt_wrapException");
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        super.visit(statement);
        if (this.async) {
            this.consumer.consume(MONITOR_ENTER_METHOD);
            this.consumer.consumeFunction("$rt_suspending");
        } else {
            this.consumer.consume(MONITOR_ENTER_SYNC_METHOD);
        }
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        super.visit(statement);
        if (this.async) {
            this.consumer.consume(MONITOR_EXIT_METHOD);
        } else {
            this.consumer.consume(MONITOR_EXIT_SYNC_METHOD);
        }
    }

    @Override
    public void visit(BinaryExpr expr) {
        super.visit(expr);
        switch (expr.getOperation()) {
            case COMPARE: {
                this.consumer.consumeFunction("$rt_compare");
                break;
            }
            case MULTIPLY: {
                if (expr.getType() != OperationType.INT || RenderingUtil.isSmallInteger(expr.getFirstOperand()) || RenderingUtil.isSmallInteger(expr.getSecondOperand())) break;
                this.consumer.consumeFunction("$rt_imul");
                break;
            }
        }
    }

    @Override
    public void visit(UnaryExpr expr) {
        super.visit(expr);
        switch (expr.getOperation()) {
            case NULL_CHECK: {
                this.consumer.consumeFunction("$rt_nullCheck");
                break;
            }
        }
    }

    @Override
    public void visit(ConstantExpr expr) {
        if (expr.getValue() instanceof ValueType) {
            this.visitType((ValueType)expr.getValue());
        } else if (expr.getValue() instanceof String) {
            this.consumer.consumeFunction("$rt_s");
        }
    }

    private void visitType(ValueType type) {
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            String clsName = ((ValueType.Object)type).getClassName();
            this.consumer.consume(clsName);
            this.consumer.consumeFunction("$rt_cls");
        }
    }

    @Override
    public void visit(InvocationExpr expr) {
        super.visit(expr);
        if (this.injectedMethods.contains(expr.getMethod())) {
            return;
        }
        switch (expr.getType()) {
            case SPECIAL: 
            case STATIC: {
                this.consumer.consume(expr.getMethod());
                break;
            }
            case CONSTRUCTOR: {
                this.consumer.consumeInit(expr.getMethod());
                break;
            }
            case DYNAMIC: {
                this.consumer.consume(expr.getMethod().getDescriptor());
            }
        }
    }

    @Override
    public void visit(QualificationExpr expr) {
        super.visit(expr);
        this.consumer.consume(expr.getField());
    }

    @Override
    public void visit(NewExpr expr) {
        super.visit(expr);
        this.consumer.consume(expr.getConstructedClass());
    }

    @Override
    public void visit(NewArrayExpr expr) {
        super.visit(expr);
        this.visitType(expr.getType());
        if (!(expr.getType() instanceof ValueType.Primitive)) {
            this.consumer.consumeFunction("$rt_createArray");
        }
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        super.visit(expr);
        this.visitType(expr.getType());
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        super.visit(expr);
        this.visitType(expr.getType());
        if (expr.getType() instanceof ValueType.Object) {
            String clsName = ((ValueType.Object)expr.getType()).getClassName();
            ClassReader cls = this.classSource.get(clsName);
            if (cls == null || cls.hasModifier(ElementModifier.INTERFACE)) {
                this.consumer.consumeFunction("$rt_isInstance");
            }
        } else {
            this.consumer.consumeFunction("$rt_isInstance");
        }
    }
}

