/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.teavm.ast.ControlFlowEntry;
import org.teavm.common.Graph;
import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.util.ProgramUtils;

class LocationGraphBuilder {
    private Map<TextLocation, Set<TextLocation>> graphBuilder;
    private List<Set<TextLocation>> startLocations;
    private List<AdditionalConnection> additionalConnections;

    LocationGraphBuilder() {
    }

    public ControlFlowEntry[] build(Program program) {
        this.graphBuilder = new HashMap<TextLocation, Set<TextLocation>>();
        Graph graph = ProgramUtils.buildControlFlowGraph(program);
        this.dfs(graph, program);
        return this.assemble();
    }

    private void dfs(Graph graph, Program program) {
        this.startLocations = new ArrayList<Object>(Collections.nCopies(graph.size(), null));
        this.additionalConnections = new ArrayList<AdditionalConnection>();
        ArrayDeque<Step> stack = new ArrayDeque<Step>();
        for (int i = 0; i < graph.size(); ++i) {
            if (graph.incomingEdgesCount(i) != 0) continue;
            stack.push(new Step(null, new HashSet<TextLocation>(), i));
        }
        boolean[] visited = new boolean[graph.size()];
        TextLocation[] blockLocations = new TextLocation[graph.size()];
        while (!stack.isEmpty()) {
            Step step = (Step)stack.pop();
            if (visited[step.block]) {
                if (step.location == null) continue;
                this.additionalConnections.add(new AdditionalConnection(step.location, this.startLocations.get(step.block)));
                continue;
            }
            visited[step.block] = true;
            this.startLocations.set(step.block, step.startLocations);
            BasicBlock block = program.basicBlockAt(step.block);
            TextLocation location = step.location;
            boolean started = false;
            for (Instruction insn : block) {
                if (insn instanceof JumpInstruction || insn instanceof EmptyInstruction || insn.getLocation() == null) continue;
                if (!started) {
                    step.startLocations.add(insn.getLocation());
                }
                started = true;
                if (blockLocations[step.block] == null) {
                    blockLocations[step.block] = insn.getLocation();
                }
                if (location != null && !Objects.equals(location, insn.getLocation())) {
                    this.addEdge(location, insn.getLocation());
                }
                location = insn.getLocation();
            }
            if (graph.outgoingEdgesCount(step.block) == 0) {
                if (location == null) continue;
                this.addEdge(location, new TextLocation(null, -1));
                continue;
            }
            for (Object next : (Object)graph.outgoingEdges(step.block)) {
                stack.push(new Step(location, started ? new HashSet() : step.startLocations, (int)next));
            }
        }
    }

    private ControlFlowEntry[] assemble() {
        for (AdditionalConnection additionalConn : this.additionalConnections) {
            for (TextLocation textLocation : additionalConn.successors) {
                this.addEdge(additionalConn.location, textLocation);
            }
        }
        ControlFlowEntry[] locationGraph = new ControlFlowEntry[this.graphBuilder.size()];
        int index = 0;
        for (Map.Entry entry : this.graphBuilder.entrySet()) {
            TextLocation[] successors = ((Set)entry.getValue()).toArray(new TextLocation[0]);
            for (int i = 0; i < successors.length; ++i) {
                if (successors[i] == null || successors[i].getLine() >= 0) continue;
                successors[i] = null;
            }
            locationGraph[index++] = new ControlFlowEntry((TextLocation)entry.getKey(), successors);
        }
        return locationGraph;
    }

    private void addEdge(TextLocation source, TextLocation dest) {
        Set<TextLocation> successors = this.graphBuilder.get(source);
        if (successors == null) {
            successors = new HashSet<TextLocation>();
            this.graphBuilder.put(source, successors);
        }
        successors.add(dest);
    }

    static class AdditionalConnection {
        TextLocation location;
        Set<TextLocation> successors;

        AdditionalConnection(TextLocation location, Set<TextLocation> successors) {
            this.location = location;
            this.successors = successors;
        }
    }

    static class Step {
        TextLocation location;
        Set<TextLocation> startLocations;
        int block;

        Step(TextLocation location, Set<TextLocation> startLocations, int block) {
            this.location = location;
            this.startLocations = startLocations;
            this.block = block;
        }
    }
}

