/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.function.Function;
import org.teavm.backend.javascript.ProviderContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

class GeneratorAnnotationInstaller<T>
implements Function<ProviderContext, T> {
    private T generator;
    private String annotationName;

    GeneratorAnnotationInstaller(T generator, String annotationName) {
        this.generator = generator;
        this.annotationName = annotationName;
    }

    @Override
    public T apply(ProviderContext providerContext) {
        MethodReference methodRef;
        ClassReaderSource classSource = providerContext.getClassSource();
        ClassReader cls = classSource.get((methodRef = providerContext.getMethod()).getClassName());
        if (cls == null) {
            return null;
        }
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        if (method == null) {
            return null;
        }
        return method.getAnnotations().get(this.annotationName) != null ? (T)this.generator : null;
    }
}

