/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.devserver.deobfuscate;

import java.io.IOException;
import java.util.ArrayList;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.SourceLocation;
import org.teavm.devserver.deobfuscate.DeobfuscateFunction;
import org.teavm.devserver.deobfuscate.DeobfuscatorCallback;
import org.teavm.devserver.deobfuscate.Frame;
import org.teavm.devserver.deobfuscate.Int8ArrayInputStream;
import org.teavm.jso.JSBody;
import org.teavm.jso.ajax.XMLHttpRequest;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSRegExp;
import org.teavm.jso.core.JSString;
import org.teavm.jso.typedarrays.ArrayBuffer;
import org.teavm.jso.typedarrays.Int8Array;
import org.teavm.model.MethodReference;

public final class Deobfuscator {
    private static final JSRegExp FRAME_PATTERN = JSRegExp.create("^ +at ([^(]+) *\\((.+):([0-9]+):([0-9]+)\\) *$");

    private Deobfuscator() {
    }

    public static void main(String[] args) {
        Deobfuscator.loadDeobfuscator(args[0], args[1]);
    }

    private static void loadDeobfuscator(String fileName, String classesFileName) {
        XMLHttpRequest xhr = XMLHttpRequest.create();
        xhr.setResponseType("arraybuffer");
        xhr.onComplete(() -> Deobfuscator.installDeobfuscator((ArrayBuffer)xhr.getResponse().cast(), classesFileName));
        xhr.open("GET", fileName);
        xhr.send();
    }

    private static void installDeobfuscator(ArrayBuffer buffer, String classesFileName) {
        DebugInformation debugInformation;
        Int8Array array = Int8Array.create(buffer);
        try {
            debugInformation = DebugInformation.read(new Int8ArrayInputStream(array));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Deobfuscator.setDeobfuscateFunction(stack -> {
            ArrayList<Frame> frames = new ArrayList<Frame>();
            for (String line : Deobfuscator.splitLines(stack)) {
                int columnNumber;
                int lineNumber;
                JSArray<JSString> groups = FRAME_PATTERN.exec(JSString.valueOf(line));
                if (groups == null) continue;
                String functionName = ((JSString)groups.get(1)).stringValue();
                String fileName = ((JSString)groups.get(2)).stringValue();
                Frame frame = Deobfuscator.deobfuscateFrame(debugInformation, classesFileName, fileName, lineNumber = Integer.parseInt(((JSString)groups.get(3)).stringValue()), columnNumber = Integer.parseInt(((JSString)groups.get(4)).stringValue()));
                if (frame == null) {
                    frame = Deobfuscator.createDefaultFrame(fileName, functionName, lineNumber);
                }
                frames.add(frame);
            }
            return frames.toArray(new Frame[0]);
        });
        DeobfuscatorCallback callback = Deobfuscator.getCallback();
        if (callback != null) {
            callback.run();
        }
    }

    private static Frame deobfuscateFrame(DebugInformation debugInformation, String classesFileName, String fileName, int lineNumber, int columnNumber) {
        String decodedFileName;
        if (!fileName.equals(classesFileName)) {
            return null;
        }
        MethodReference method = debugInformation.getMethodAt(lineNumber - 1, columnNumber - 1);
        if (method == null) {
            return null;
        }
        SourceLocation location = debugInformation.getSourceLocation(lineNumber - 1, columnNumber - 1);
        String string = decodedFileName = location != null ? location.getFileName() : null;
        if (decodedFileName != null) {
            decodedFileName = decodedFileName.substring(decodedFileName.lastIndexOf(47) + 1);
        }
        Frame frame = Deobfuscator.createEmptyFrame();
        frame.setClassName(method.getClassName());
        frame.setMethodName(method.getName());
        frame.setFileName(decodedFileName);
        if (location != null) {
            frame.setLineNumber(location.getLine());
        }
        return frame;
    }

    private static Frame createDefaultFrame(String fileName, String functionName, int lineNumber) {
        Frame frame = Deobfuscator.createEmptyFrame();
        frame.setFileName(fileName);
        frame.setMethodName(functionName != null ? functionName : "<unknown function>");
        frame.setClassName("<JS>");
        frame.setLineNumber(lineNumber);
        return frame;
    }

    private static String[] splitLines(String text) {
        ArrayList<String> result = new ArrayList<String>();
        int index = 0;
        while (index < text.length()) {
            int next = text.indexOf(10, index);
            if (next < 0) {
                next = text.length();
            }
            result.add(text.substring(index, next));
            index = next + 1;
        }
        return result.toArray(new String[0]);
    }

    @JSBody(script="return {};")
    private static native Frame createEmptyFrame();

    @JSBody(params={"f"}, script="window.$rt_decodeStack = f;")
    private static native void setDeobfuscateFunction(DeobfuscateFunction var0);

    @JSBody(script="return typeof $teavm_deobfuscator_callback === 'function'? $teavm_deobfuscator_callback : null;")
    private static native DeobfuscatorCallback getCallback();
}

