/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import org.teavm.apachecommons.cli.CommandLine;
import org.teavm.apachecommons.cli.HelpFormatter;
import org.teavm.apachecommons.cli.OptionBuilder;
import org.teavm.apachecommons.cli.Options;
import org.teavm.apachecommons.cli.ParseException;
import org.teavm.apachecommons.cli.PosixParser;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.cli.AccumulatingTeaVMToolLog;
import org.teavm.tooling.ConsoleTeaVMToolLog;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.util.FileSystemWatcher;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;

public final class TeaVMRunner {
    private static Options options = new Options();
    private TeaVMTool tool = new TeaVMTool();
    private AccumulatingTeaVMToolLog log = new AccumulatingTeaVMToolLog(new ConsoleTeaVMToolLog(false));
    private CommandLine commandLine;
    private long startTime;
    private long phaseStartTime;
    private String[] classPath;
    private boolean interactive;

    private static void setupOptions() {
        OptionBuilder.withArgName("target");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("target type (javascript/js, webassembly/wasm, C)");
        options.addOption(OptionBuilder.create('t'));
        OptionBuilder.withArgName("directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("a directory where to put generated files (current directory by default)");
        OptionBuilder.withLongOpt("targetdir");
        options.addOption(OptionBuilder.create('d'));
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("a file where to put decompiled classes (classes.js by default)");
        OptionBuilder.withLongOpt("targetfile");
        options.addOption(OptionBuilder.create('f'));
        OptionBuilder.withDescription("causes TeaVM to generate minimized JavaScript file");
        OptionBuilder.withLongOpt("minify");
        options.addOption(OptionBuilder.create("m"));
        OptionBuilder.withDescription("optimization level (1-3)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("number");
        options.addOption(OptionBuilder.create("O"));
        OptionBuilder.withDescription("Generate debug information");
        OptionBuilder.withLongOpt("debug");
        options.addOption(OptionBuilder.create('g'));
        OptionBuilder.withDescription("Generate source maps");
        OptionBuilder.withLongOpt("sourcemaps");
        options.addOption(OptionBuilder.create('G'));
        OptionBuilder.withDescription("Incremental build");
        OptionBuilder.withLongOpt("incremental");
        options.addOption(OptionBuilder.create('i'));
        OptionBuilder.withArgName("directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Incremental build cache directory");
        OptionBuilder.withLongOpt("cachedir");
        options.addOption(OptionBuilder.create('c'));
        OptionBuilder.withDescription("Wait for command after compilation, in order to enable hot recompilation");
        OptionBuilder.withLongOpt("wait");
        options.addOption(OptionBuilder.create('w'));
        OptionBuilder.withArgName("classpath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Additional classpath that will be reloaded by TeaVM each time in wait mode");
        OptionBuilder.withLongOpt("classpath");
        options.addOption(OptionBuilder.create('p'));
        OptionBuilder.withArgName("class name");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Tell optimizer to not remove class, so that it can be found by Class.forName");
        OptionBuilder.withLongOpt("preserve-class");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("wasm-version");
        OptionBuilder.withArgName("version");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("WebAssembly binary version (currently, only 1 is supported)");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("entry-point");
        OptionBuilder.withArgName("name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Entry point name in target language (main by default)");
        options.addOption(OptionBuilder.create("e"));
        OptionBuilder.withLongOpt("min-heap");
        OptionBuilder.withArgName("size");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Minimum heap size in megabytes (for C and WebAssembly)");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("max-toplevel-names");
        OptionBuilder.withArgName("number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Maximum number of names kept in top-level scope (other will be put in a separate object. 10000 by default.");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("no-longjmp");
        OptionBuilder.withDescription("Don't use setjmp/longjmp functions to emulate exceptions (C target)");
        options.addOption(OptionBuilder.create());
    }

    private TeaVMRunner(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        if (args.length == 0) {
            TeaVMRunner.printUsage();
            return;
        }
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMRunner.printUsage();
            return;
        }
        TeaVMRunner runner = new TeaVMRunner(commandLine);
        runner.parseArguments();
        runner.setUp();
        runner.runAll();
    }

    private void parseArguments() {
        this.parseClassPathOptions();
        this.parseTargetOption();
        this.parseOutputOptions();
        this.parseDebugOptions();
        this.parsePreserveClassOptions();
        this.parseOptimizationOption();
        this.parseIncrementalOptions();
        this.parseJavaScriptOptions();
        this.parseWasmOptions();
        this.parseCOptions();
        this.parseHeap();
        if (this.commandLine.hasOption("e")) {
            this.tool.setEntryPointName(this.commandLine.getOptionValue("e"));
        }
        this.interactive = this.commandLine.hasOption('w');
        String[] args = this.commandLine.getArgs();
        if (args.length > 1) {
            System.err.println("Unexpected arguments");
            TeaVMRunner.printUsage();
        } else if (args.length == 1) {
            this.tool.setMainClass(args[0]);
        }
    }

    private void parseTargetOption() {
        if (this.commandLine.hasOption("t")) {
            switch (this.commandLine.getOptionValue('t').toLowerCase()) {
                case "javascript": 
                case "js": {
                    this.tool.setTargetType(TeaVMTargetType.JAVASCRIPT);
                    break;
                }
                case "webassembly": 
                case "wasm": {
                    this.tool.setTargetType(TeaVMTargetType.WEBASSEMBLY);
                    break;
                }
                case "c": {
                    this.tool.setTargetType(TeaVMTargetType.C);
                }
            }
        }
    }

    private void parseOutputOptions() {
        if (this.commandLine.hasOption("d")) {
            this.tool.setTargetDirectory(new File(this.commandLine.getOptionValue("d")));
        }
        if (this.commandLine.hasOption("f")) {
            this.tool.setTargetFileName(this.commandLine.getOptionValue("f"));
        }
    }

    private void parseJavaScriptOptions() {
        this.tool.setMinifying(this.commandLine.hasOption("m"));
        if (this.commandLine.hasOption("max-toplevel-names")) {
            try {
                this.tool.setMaxTopLevelNames(Integer.parseInt(this.commandLine.getOptionValue("max-toplevel-names")));
            }
            catch (NumberFormatException e) {
                System.err.println("'--max-toplevel-names' must be integer number");
                TeaVMRunner.printUsage();
            }
        }
    }

    private void parseDebugOptions() {
        if (this.commandLine.hasOption('g')) {
            this.tool.setDebugInformationGenerated(true);
        }
        if (this.commandLine.hasOption('G')) {
            this.tool.setSourceMapsFileGenerated(true);
        }
    }

    private void parsePreserveClassOptions() {
        if (this.commandLine.hasOption("preserve-class")) {
            this.tool.getClassesToPreserve().addAll(Arrays.asList(this.commandLine.getOptionValues("preserve-class")));
        }
    }

    private void parseOptimizationOption() {
        if (this.commandLine.hasOption("O")) {
            int level;
            try {
                level = Integer.parseInt(this.commandLine.getOptionValue("O"));
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong optimization level");
                TeaVMRunner.printUsage();
                return;
            }
            switch (level) {
                case 1: {
                    this.tool.setOptimizationLevel(TeaVMOptimizationLevel.SIMPLE);
                    break;
                }
                case 2: {
                    this.tool.setOptimizationLevel(TeaVMOptimizationLevel.ADVANCED);
                    break;
                }
                case 3: {
                    this.tool.setOptimizationLevel(TeaVMOptimizationLevel.FULL);
                    break;
                }
                default: {
                    System.err.print("Wrong optimization level");
                    TeaVMRunner.printUsage();
                }
            }
        }
    }

    private void parseIncrementalOptions() {
        if (this.commandLine.hasOption('i')) {
            this.tool.setIncremental(true);
        }
        if (this.commandLine.hasOption('c')) {
            this.tool.setCacheDirectory(new File(this.commandLine.getOptionValue('c')));
        } else {
            this.tool.setCacheDirectory(new File(this.tool.getTargetDirectory(), "teavm-cache"));
        }
    }

    private void parseClassPathOptions() {
        if (this.commandLine.hasOption('p')) {
            this.classPath = this.commandLine.getOptionValues('p');
        }
    }

    private void parseWasmOptions() {
        if (this.commandLine.hasOption("wasm-version")) {
            String value = this.commandLine.getOptionValue("wasm-version");
            try {
                int version = Integer.parseInt(value);
                switch (version) {
                    case 1: {
                        this.tool.setWasmVersion(WasmBinaryVersion.V_0x1);
                        break;
                    }
                    default: {
                        System.err.print("Wrong version value");
                        TeaVMRunner.printUsage();
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong version value");
                TeaVMRunner.printUsage();
            }
        }
    }

    private void parseCOptions() {
        if (this.commandLine.hasOption("no-longjmp")) {
            this.tool.setLongjmpSupported(false);
        }
        if (this.commandLine.hasOption("heap-dump")) {
            this.tool.setHeapDump(true);
        }
    }

    private void parseHeap() {
        if (this.commandLine.hasOption("min-heap")) {
            int size;
            try {
                size = Integer.parseInt(this.commandLine.getOptionValue("min-heap"));
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong heap size");
                TeaVMRunner.printUsage();
                return;
            }
            this.tool.setMinHeapSize(size * 1024 * 1024);
        }
    }

    private void setUp() {
        this.tool.setLog(this.log);
        this.tool.getProperties().putAll((Map<?, ?>)System.getProperties());
    }

    private void runAll() {
        if (this.interactive) {
            this.buildInteractive();
        } else {
            this.buildNonInteractive();
        }
    }

    private void buildInteractive() {
        FileSystemWatcher watcher;
        try {
            watcher = new FileSystemWatcher(this.classPath);
        }
        catch (IOException e) {
            System.err.println("Error listening file system events");
            e.printStackTrace();
            System.exit(2);
            return;
        }
        while (true) {
            ProgressListenerImpl progressListener = new ProgressListenerImpl(watcher);
            try {
                this.build(progressListener);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            try {
                System.out.println("Waiting for changes...");
                watcher.waitForChange(750);
                watcher.grabChangedFiles();
                System.out.println();
                System.out.println("Changes detected. Recompiling...");
            }
            catch (IOException | InterruptedException e) {
                return;
            }
        }
    }

    private void buildNonInteractive() {
        try {
            this.build(new ProgressListenerImpl(null));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-2);
        }
        if (!this.tool.getProblemProvider().getSevereProblems().isEmpty()) {
            System.exit(-2);
        }
    }

    private void build(ProgressListenerImpl progressListener) throws TeaVMToolException {
        this.tool.setProgressListener(progressListener);
        this.resetClassLoader();
        this.startTime = System.currentTimeMillis();
        this.phaseStartTime = System.currentTimeMillis();
        this.tool.generate();
        this.reportPhaseComplete();
        TeaVMProblemRenderer.describeProblems(this.tool.getDependencyInfo().getCallGraph(), this.tool.getProblemProvider(), this.log);
        this.log.flush();
        System.out.println("Build complete for " + (double)(System.currentTimeMillis() - this.startTime) / 1000.0 + " seconds");
    }

    private void resetClassLoader() {
        if (this.classPath == null || this.classPath.length == 0) {
            return;
        }
        URL[] urls = new URL[this.classPath.length];
        for (int i = 0; i < this.classPath.length; ++i) {
            try {
                urls[i] = new File(this.classPath[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                System.err.println("Illegal classpath entry: " + this.classPath[i]);
                System.exit(-1);
                return;
            }
        }
        this.tool.setClassLoader(new URLClassLoader(urls, TeaVMRunner.class.getClassLoader()));
    }

    private void reportPhaseComplete() {
        System.out.println(" complete for " + (double)(System.currentTimeMillis() - this.phaseStartTime) / 1000.0 + " seconds");
        this.log.flush();
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMRunner.class.getName() + " [OPTIONS] [qualified.main.Class]", options);
        System.exit(-1);
    }

    static {
        TeaVMRunner.setupOptions();
    }

    class ProgressListenerImpl
    implements TeaVMProgressListener {
        private TeaVMPhase currentPhase;
        private FileSystemWatcher fileSystemWatcher;

        ProgressListenerImpl(FileSystemWatcher fileSystemWatcher) {
            this.fileSystemWatcher = fileSystemWatcher;
        }

        @Override
        public TeaVMProgressFeedback progressReached(int progress) {
            return this.getStatus();
        }

        @Override
        public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int count) {
            TeaVMRunner.this.log.flush();
            if (this.currentPhase != phase) {
                if (this.currentPhase != null) {
                    TeaVMRunner.this.reportPhaseComplete();
                }
                TeaVMRunner.this.phaseStartTime = System.currentTimeMillis();
                switch (phase) {
                    case DEPENDENCY_ANALYSIS: {
                        System.out.print("Analyzing classes...");
                        break;
                    }
                    case COMPILING: {
                        System.out.print("Compiling...");
                    }
                }
                this.currentPhase = phase;
            }
            return this.getStatus();
        }

        private TeaVMProgressFeedback getStatus() {
            try {
                if (this.fileSystemWatcher != null && this.fileSystemWatcher.hasChanges()) {
                    System.out.println("Classes changed during compilation. Canceling.");
                    return TeaVMProgressFeedback.CANCEL;
                }
                return TeaVMProgressFeedback.CONTINUE;
            }
            catch (IOException e) {
                throw new RuntimeException("IO error occurred");
            }
        }
    }
}

