/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.stream.TCollector;

public final class TCollectors {
    private TCollectors() {
    }

    public static <T, C extends Collection<T>> TCollector<T, ?, C> toCollection(Supplier<C> collectionFactory) {
        return TCollector.of(collectionFactory, Collection::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, new TCollector.Characteristics[0]);
    }

    public static <T> TCollector<T, ?, List<T>> toList() {
        return TCollectors.toCollection(ArrayList::new);
    }

    public static <T> TCollector<T, ?, Set<T>> toSet() {
        return TCollectors.toCollection(HashSet::new);
    }

    public static TCollector<CharSequence, ?, String> joining() {
        return TCollector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, StringBuilder::toString, new TCollector.Characteristics[0]);
    }

    public static TCollector<CharSequence, ?, String> joining(CharSequence delimiter) {
        return TCollectors.joining(delimiter, "", "");
    }

    public static TCollector<CharSequence, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        BiConsumer<StringBuilder, CharSequence> accumulator = (sb, item) -> {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append((CharSequence)item);
        };
        BinaryOperator combiner = (a, b) -> {
            if (a.length() > 0) {
                a.append(delimiter);
            }
            return a.append((CharSequence)b);
        };
        return TCollector.of(StringBuilder::new, accumulator, combiner, sb -> sb.insert(0, prefix).append(suffix).toString(), new TCollector.Characteristics[0]);
    }
}

