/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.teavm.classlib.java.io.TBufferedInputStream;
import org.teavm.classlib.java.io.TInputStream;
import org.teavm.classlib.java.io.TPrintStream;
import org.teavm.classlib.java.util.TDate;
import org.teavm.classlib.java.util.TEnumeration;
import org.teavm.classlib.java.util.THashSet;
import org.teavm.classlib.java.util.THashtable;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TSet;

public class TProperties
extends THashtable<Object, Object> {
    protected TProperties defaults;
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private static final int CONTINUE = 3;
    private static final int KEY_DONE = 4;
    private static final int IGNORE = 5;

    public TProperties() {
    }

    public TProperties(TProperties properties) {
        this.defaults = properties;
    }

    private void dumpString(StringBuilder buffer, String string, boolean isKey) {
        int index = 0;
        int length = string.length();
        if (!isKey && index < length && string.charAt(index) == ' ') {
            buffer.append("\\ ");
            ++index;
        }
        while (index < length) {
            char ch = string.charAt(index);
            switch (ch) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if ("\\#!=:".indexOf(ch) >= 0 || isKey && ch == ' ') {
                        buffer.append('\\');
                    }
                    if (ch >= ' ' && ch <= '~') {
                        buffer.append(ch);
                        break;
                    }
                    buffer.append(this.toHexaDecimal(ch));
                }
            }
            ++index;
        }
    }

    private char[] toHexaDecimal(int ch) {
        char[] hexChars = new char[]{'\\', 'u', '0', '0', '0', '0'};
        int index = hexChars.length;
        int copyOfCh = ch;
        do {
            int hexChar;
            hexChar = (hexChar = copyOfCh & 0xF) > 9 ? hexChar - 10 + 65 : (hexChar += 48);
            hexChars[--index] = (char)hexChar;
        } while ((copyOfCh >>>= 4) != 0);
        return hexChars;
    }

    public String getProperty(String name) {
        String property;
        Object result = super.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        return property;
    }

    public String getProperty(String name, String defaultValue) {
        String property;
        Object result = super.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        if (property == null) {
            return defaultValue;
        }
        return property;
    }

    public void list(TPrintStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        StringBuilder buffer = new StringBuilder(80);
        TEnumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buffer.append(key);
            buffer.append('=');
            String property = (String)super.get(key);
            TProperties def = this.defaults;
            while (property == null) {
                property = (String)def.get(key);
                def = def.defaults;
            }
            if (property.length() > 40) {
                buffer.append(property.substring(0, 37));
                buffer.append("...");
            } else {
                buffer.append(property);
            }
            out.println(buffer.toString());
            buffer.setLength(0);
        }
    }

    public synchronized void load(TInputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        int mode = 0;
        int unicode = 0;
        int count = 0;
        char[] buf = new char[40];
        int offset = 0;
        int keyLength = -1;
        boolean firstChar = true;
        TBufferedInputStream bis = new TBufferedInputStream(in);
        block17: while (true) {
            int intVal;
            if ((intVal = bis.read()) == -1) {
                if (mode == 2 && count < 4) {
                    throw new IllegalArgumentException("Invalid Unicode sequence: expected format \\uxxxx");
                }
                if (mode != 1) break;
                buf[offset++] = '\u0000';
                break;
            }
            char nextChar = (char)(intVal & 0xFF);
            if (offset == buf.length) {
                char[] newBuf = new char[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, offset);
                buf = newBuf;
            }
            if (mode == 2) {
                int digit = Character.digit(nextChar, 16);
                if (digit >= 0) {
                    unicode = (unicode << 4) + digit;
                    if (++count < 4) {
                        continue;
                    }
                } else if (count <= 4) {
                    throw new IllegalArgumentException("Invalid Unicode sequence: illegal character");
                }
                mode = 0;
                buf[offset++] = (char)unicode;
                if (nextChar != '\n') continue;
            }
            if (mode == 1) {
                mode = 0;
                switch (nextChar) {
                    case '\r': {
                        mode = 3;
                        continue block17;
                    }
                    case '\n': {
                        mode = 5;
                        continue block17;
                    }
                    case 'b': {
                        nextChar = '\b';
                        break;
                    }
                    case 'f': {
                        nextChar = '\f';
                        break;
                    }
                    case 'n': {
                        nextChar = '\n';
                        break;
                    }
                    case 'r': {
                        nextChar = '\r';
                        break;
                    }
                    case 't': {
                        nextChar = '\t';
                        break;
                    }
                    case 'u': {
                        mode = 2;
                        unicode = 0;
                        count = 0;
                        continue block17;
                    }
                }
            } else {
                switch (nextChar) {
                    case '!': 
                    case '#': {
                        if (!firstChar) break;
                        while ((intVal = bis.read()) != -1 && (nextChar = (char)intVal) != '\r' && nextChar != '\n') {
                        }
                        continue block17;
                    }
                    case '\n': {
                        if (mode != 3) break;
                        mode = 5;
                        continue block17;
                    }
                    case '\r': {
                        if (mode == 3) {
                            mode = 5;
                            continue block17;
                        }
                        mode = 0;
                        firstChar = true;
                        if (offset > 0 || offset == 0 && keyLength == 0) {
                            if (keyLength == -1) {
                                keyLength = offset;
                            }
                            String temp = new String(buf, 0, offset);
                            this.put(temp.substring(0, keyLength), temp.substring(keyLength));
                        }
                        keyLength = -1;
                        offset = 0;
                        continue block17;
                    }
                    case '\\': {
                        if (mode == 4) {
                            keyLength = offset;
                        }
                        mode = 1;
                        continue block17;
                    }
                    case ':': 
                    case '=': {
                        if (keyLength != -1) break;
                        mode = 0;
                        keyLength = offset;
                        continue block17;
                    }
                }
                if (nextChar < '\u0100' && Character.isWhitespace(nextChar)) {
                    if (mode == 3) {
                        mode = 5;
                    }
                    if (offset == 0 || offset == keyLength || mode == 5) continue;
                    if (keyLength == -1) {
                        mode = 4;
                        continue;
                    }
                }
                if (mode == 5 || mode == 3) {
                    mode = 0;
                }
            }
            firstChar = false;
            if (mode == 4) {
                keyLength = offset;
                mode = 0;
            }
            buf[offset++] = nextChar;
        }
        if (keyLength == -1 && offset > 0) {
            keyLength = offset;
        }
        if (keyLength >= 0) {
            String temp = new String(buf, 0, offset);
            this.put(temp.substring(0, keyLength), temp.substring(keyLength));
        }
    }

    public TEnumeration<?> propertyNames() {
        THashtable<Object, Object> selected = new THashtable<Object, Object>();
        this.selectProperties(selected);
        return selected.keys();
    }

    private void selectProperties(TMap<Object, Object> selected) {
        if (this.defaults != null) {
            this.defaults.selectProperties(selected);
        }
        selected.putAll(this);
    }

    @Deprecated
    public void save(OutputStream out, String comment) {
        try {
            this.store(out, comment);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object setProperty(String name, String value) {
        return this.put(name, value);
    }

    public synchronized void store(OutputStream out, String comments) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "ISO8859_1");
        if (comments != null) {
            this.writeComments(writer, comments);
        }
        writer.write(35);
        writer.write(new TDate().toString());
        writer.write("\n");
        StringBuilder buffer = new StringBuilder(200);
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            String key = (String)entry.getKey();
            this.dumpString(buffer, key, true);
            buffer.append('=');
            this.dumpString(buffer, (String)entry.getValue(), false);
            buffer.append("\n");
            writer.write(buffer.toString());
            buffer.setLength(0);
        }
        writer.flush();
    }

    private void writeComments(Writer writer, String comments) throws IOException {
        writer.write(35);
        char[] chars = comments.toCharArray();
        for (int index = 0; index < chars.length; ++index) {
            if (chars[index] == '\r' || chars[index] == '\n') {
                int indexPlusOne = index + 1;
                if (chars[index] == '\r' && indexPlusOne < chars.length && chars[indexPlusOne] == '\n') continue;
                writer.write("\n");
                if (indexPlusOne < chars.length && (chars[indexPlusOne] == '#' || chars[indexPlusOne] == '!')) continue;
                writer.write(35);
                continue;
            }
            writer.write(chars[index]);
        }
        writer.write("\n");
    }

    public TSet<String> stringPropertyNames() {
        THashSet<String> selected = new THashSet<String>();
        this.selectPropertyNames(selected);
        return selected;
    }

    private void selectPropertyNames(TSet<String> selected) {
        if (this.defaults != null) {
            this.defaults.selectPropertyNames(selected);
        }
        TEnumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (!(key instanceof String)) continue;
            selected.add((String)key);
        }
    }
}

