/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.NoSuchElementException;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public class TOptionalLong {
    private static TOptionalLong emptyInstance;
    private final long value;

    private TOptionalLong(long value) {
        this.value = value;
    }

    public static TOptionalLong empty() {
        if (emptyInstance == null) {
            emptyInstance = new TOptionalLong(0L);
        }
        return emptyInstance;
    }

    public static TOptionalLong of(long value) {
        return new TOptionalLong(value);
    }

    public long getAsLong() {
        if (this == emptyInstance) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public boolean isPresent() {
        return this != emptyInstance;
    }

    public void ifPresent(LongConsumer consumer) {
        if (this != emptyInstance) {
            consumer.accept(this.value);
        }
    }

    public long orElse(long other) {
        return this != emptyInstance ? this.value : other;
    }

    public long orElseGet(LongSupplier other) {
        return this != emptyInstance ? this.value : other.getAsLong();
    }

    public <X extends Throwable> long orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (!this.isPresent()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TOptionalLong)) {
            return false;
        }
        return ((TOptionalLong)obj).value == this.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public String toString() {
        return this.isPresent() ? "OptionalLong.of(" + this.value + ")" : "OptionalLong.empty()";
    }
}

