/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.util.TEnumSet;
import org.teavm.platform.Platform;

class TGenericEnumSet<E extends Enum<E>>
extends TEnumSet<E> {
    Class<E> cls;
    int[] bits;

    TGenericEnumSet(Class<E> cls) {
        this.cls = cls;
        int constantCount = TGenericEnumSet.getConstants(cls).length;
        int bitCount = (constantCount - 1) / 32 + 1;
        this.bits = new int[bitCount];
    }

    TGenericEnumSet(Class<E> cls, int[] bits) {
        this.cls = cls;
        this.bits = bits;
    }

    static Enum<?>[] getConstants(Class<?> cls) {
        return Platform.getEnumConstants(((TClass)((Object)cls)).getPlatformClass());
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int index;
            int indexToRemove = -1;
            int count = TGenericEnumSet.this.size();

            @Override
            public boolean hasNext() {
                return this.count > 0;
            }

            @Override
            public E next() {
                if (this.count == 0) {
                    throw new NoSuchElementException();
                }
                this.indexToRemove = this.index;
                while (true) {
                    int next;
                    if ((next = Integer.numberOfTrailingZeros(TGenericEnumSet.this.bits[this.index / 32] >>> this.index % 32)) < 32) {
                        this.index += next;
                        --this.count;
                        Enum returnValue = TGenericEnumSet.getConstants(TGenericEnumSet.this.cls)[this.index++];
                        return returnValue;
                    }
                    this.index = (this.index / 32 + 1) * 32;
                }
            }

            @Override
            public void remove() {
                int bitNumber;
                if (this.indexToRemove < 0) {
                    throw new IllegalStateException();
                }
                int n = bitNumber = this.indexToRemove / 32;
                TGenericEnumSet.this.bits[n] = TGenericEnumSet.this.bits[n] & ~(1 << this.indexToRemove % 32);
                this.indexToRemove = -1;
            }
        };
    }

    @Override
    public int size() {
        int result = 0;
        for (int bit : this.bits) {
            result += Integer.bitCount(bit);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TGenericEnumSet)) {
            return false;
        }
        TGenericEnumSet other = (TGenericEnumSet)o;
        return this.cls == other.cls && Arrays.equals(this.bits, other.bits);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bits);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof TGenericEnumSet) {
            TGenericEnumSet other = (TGenericEnumSet)c;
            if (this.cls == other.cls) {
                boolean changed = false;
                for (int i = 0; i < this.bits.length; ++i) {
                    int inv = ~other.bits[i];
                    if ((this.bits[i] & inv) == this.bits[i]) continue;
                    changed = true;
                    int n = i;
                    this.bits[n] = this.bits[n] & inv;
                }
                return changed;
            }
        }
        return super.removeAll(c);
    }

    @Override
    public boolean contains(Object o) {
        int bit;
        if (!this.cls.isInstance(o)) {
            return false;
        }
        int n = ((Enum)o).ordinal();
        int bitNumber = n / 32;
        return (this.bits[bitNumber] & (bit = 1 << n % 32)) != 0;
    }

    @Override
    void fastAdd(E t) {
        int bitNumber;
        int n = ((Enum)t).ordinal();
        int n2 = bitNumber = n / 32;
        this.bits[n2] = this.bits[n2] | 1 << n % 32;
    }

    @Override
    public boolean add(E t) {
        int bit;
        int n = ((Enum)t).ordinal();
        int bitNumber = n / 32;
        if ((this.bits[bitNumber] & (bit = 1 << n % 32)) == 0) {
            int n2 = bitNumber;
            this.bits[n2] = this.bits[n2] | bit;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        int bit;
        if (!this.cls.isInstance(o)) {
            return false;
        }
        int n = ((Enum)o).ordinal();
        int bitNumber = n / 32;
        if ((this.bits[bitNumber] & (bit = 1 << n % 32)) != 0) {
            int n2 = bitNumber;
            this.bits[n2] = this.bits[n2] & ~bit;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof TGenericEnumSet) {
            TGenericEnumSet other = (TGenericEnumSet)c;
            if (this.cls == other.cls) {
                for (int i = 0; i < this.bits.length; ++i) {
                    if ((this.bits[i] | other.bits[i]) == this.bits[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return super.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c instanceof TGenericEnumSet) {
            TGenericEnumSet other = (TGenericEnumSet)c;
            if (this.cls == other.cls) {
                boolean added = false;
                for (int i = 0; i < this.bits.length; ++i) {
                    if ((this.bits[i] | other.bits[i]) == this.bits[i]) continue;
                    added = true;
                    int n = i;
                    this.bits[n] = this.bits[n] | other.bits[i];
                }
                return added;
            }
        }
        return super.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof TGenericEnumSet) {
            TGenericEnumSet other = (TGenericEnumSet)c;
            if (this.cls == other.cls) {
                boolean changed = false;
                for (int i = 0; i < this.bits.length; ++i) {
                    if ((this.bits[i] & other.bits[i]) == this.bits[i]) continue;
                    changed = true;
                    int n = i;
                    this.bits[n] = this.bits[n] & other.bits[i];
                }
                return changed;
            }
        }
        return super.retainAll(c);
    }

    @Override
    public void clear() {
        Arrays.fill(this.bits, 0);
    }
}

