/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.lang.TIllegalStateException;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TQueue;

public abstract class TAbstractQueue<E>
extends TAbstractCollection<E>
implements TQueue<E> {
    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new TIllegalStateException();
    }

    @Override
    public E remove() {
        if (this.isEmpty()) {
            throw new TNoSuchElementException();
        }
        return this.poll();
    }

    @Override
    public E element() {
        if (this.isEmpty()) {
            throw new TNoSuchElementException();
        }
        return this.peek();
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.poll();
        }
    }

    @Override
    public boolean addAll(TCollection<? extends E> c) {
        boolean oneAdded = false;
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            oneAdded |= this.add(iter.next());
        }
        return oneAdded;
    }
}

