/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRDecimalData;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.classlib.impl.unicode.DecimalData;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;

public class DecimalMetadataGenerator
implements MetadataGenerator {
    @Override
    public Resource generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        CLDRReader reader = context.getService(CLDRReader.class);
        ResourceMap<DecimalData> map = context.createResourceMap();
        for (Map.Entry<String, CLDRLocale> entry : reader.getKnownLocales().entrySet()) {
            CLDRDecimalData data = entry.getValue().getDecimalData();
            DecimalData dataRes = context.createResource(DecimalData.class);
            dataRes.setDecimalSeparator(data.getDecimalSeparator());
            dataRes.setExponentSeparator(data.getExponentSeparator());
            dataRes.setGroupingSeparator(data.getGroupingSeparator());
            dataRes.setInfinity(data.getInfinity());
            dataRes.setListSeparator(data.getListSeparator());
            dataRes.setMinusSign(data.getMinusSign());
            dataRes.setNaN(data.getNaN());
            dataRes.setPercent(data.getPercent());
            dataRes.setPerMille(data.getPerMille());
            map.put(entry.getKey(), dataRes);
        }
        return map;
    }
}

