/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmMemorySegment;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.render.WasmBinaryRenderingVisitor;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.backend.wasm.render.WasmBinaryWriter;
import org.teavm.backend.wasm.render.WasmSignature;
import org.teavm.backend.wasm.render.WasmSignatureCollector;

public class WasmBinaryRenderer {
    private static final int SECTION_UNKNOWN = 0;
    private static final int SECTION_TYPE = 1;
    private static final int SECTION_IMPORT = 2;
    private static final int SECTION_FUNCTION = 3;
    private static final int SECTION_TABLE = 4;
    private static final int SECTION_MEMORY = 5;
    private static final int SECTION_EXPORT = 7;
    private static final int SECTION_START = 8;
    private static final int SECTION_ELEMENT = 9;
    private static final int SECTION_CODE = 10;
    private static final int SECTION_DATA = 11;
    private static final int EXTERNAL_KIND_FUNCTION = 0;
    private static final int EXTERNAL_KIND_MEMORY = 2;
    private WasmBinaryWriter output;
    private WasmBinaryVersion version;
    private List<WasmSignature> signatures = new ArrayList<WasmSignature>();
    private Map<WasmSignature, Integer> signatureIndexes = new HashMap<WasmSignature, Integer>();
    private Map<String, Integer> functionIndexes = new HashMap<String, Integer>();

    public WasmBinaryRenderer(WasmBinaryWriter output, WasmBinaryVersion version) {
        this.output = output;
        this.version = version;
    }

    public void render(WasmModule module) {
        this.output.writeInt32(1836278016);
        switch (this.version) {
            case V_0x1: {
                this.output.writeInt32(1);
            }
        }
        this.renderSignatures(module);
        this.renderImports(module);
        this.renderFunctions(module);
        this.renderTable(module);
        this.renderMemory(module);
        this.renderExport(module);
        this.renderStart(module);
        this.renderElement(module);
        this.renderCode(module);
        this.renderData(module);
        this.renderNames(module);
    }

    private void renderSignatures(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        WasmSignatureCollector signatureCollector = new WasmSignatureCollector(this::registerSignature);
        for (WasmFunction function : module.getFunctions().values()) {
            this.registerSignature(WasmSignature.fromFunction(function));
            for (WasmExpression part : function.getBody()) {
                part.acceptVisitor(signatureCollector);
            }
        }
        section.writeLEB(this.signatures.size());
        for (WasmSignature signature : this.signatures) {
            section.writeByte(96);
            section.writeLEB(signature.types.length - 1);
            for (int i = 1; i < signature.types.length; ++i) {
                section.writeType(signature.types[i], this.version);
            }
            if (signature.types[0] != null) {
                section.writeByte(1);
                section.writeType(signature.types[0], this.version);
                continue;
            }
            section.writeByte(0);
        }
        this.writeSection(1, "type", section.getData());
    }

    private void renderImports(WasmModule module) {
        ArrayList<WasmFunction> functions = new ArrayList<WasmFunction>();
        for (WasmFunction function : module.getFunctions().values()) {
            if (function.getImportName() == null) continue;
            this.functionIndexes.put(function.getName(), functions.size());
            functions.add(function);
        }
        if (functions.isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(functions.size());
        for (WasmFunction function : functions) {
            WasmSignature signature = WasmSignature.fromFunction(function);
            int signatureIndex = this.signatureIndexes.get(signature);
            String moduleName = function.getImportModule();
            if (moduleName == null) {
                moduleName = "";
            }
            section.writeAsciiString(moduleName);
            section.writeAsciiString(function.getImportName());
            section.writeByte(0);
            section.writeLEB(signatureIndex);
        }
        this.writeSection(2, "import", section.getData());
    }

    private void renderFunctions(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        List functions = module.getFunctions().values().stream().filter(function -> function.getImportName() == null).collect(Collectors.toList());
        for (WasmFunction function2 : functions) {
            this.functionIndexes.put(function2.getName(), this.functionIndexes.size());
        }
        section.writeLEB(functions.size());
        for (WasmFunction function2 : functions) {
            WasmSignature signature = WasmSignature.fromFunction(function2);
            section.writeLEB(this.signatureIndexes.get(signature));
        }
        this.writeSection(3, "function", section.getData());
    }

    private void renderTable(WasmModule module) {
        if (module.getFunctionTable().isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeByte(1);
        section.writeByte(112);
        section.writeByte(0);
        section.writeLEB(this.functionIndexes.size());
        this.writeSection(4, "table", section.getData());
    }

    private void renderMemory(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeByte(1);
        section.writeByte(1);
        section.writeLEB(module.getMemorySize());
        section.writeLEB(module.getMemorySize());
        this.writeSection(5, "memory", section.getData());
    }

    private void renderExport(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        List functions = module.getFunctions().values().stream().filter(function -> function.getExportName() != null).collect(Collectors.toList());
        section.writeLEB(functions.size() + 1);
        for (WasmFunction function2 : functions) {
            int functionIndex = this.functionIndexes.get(function2.getName());
            section.writeAsciiString(function2.getExportName());
            section.writeByte(0);
            section.writeLEB(functionIndex);
        }
        section.writeAsciiString("memory");
        section.writeByte(2);
        section.writeLEB(0);
        this.writeSection(7, "export", section.getData());
    }

    private void renderStart(WasmModule module) {
        if (module.getStartFunction() == null) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(this.functionIndexes.get(module.getStartFunction().getName()));
        this.writeSection(8, "start", section.getData());
    }

    private void renderElement(WasmModule module) {
        if (module.getFunctionTable().isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(1);
        section.writeLEB(0);
        this.renderInitializer(section, 0);
        section.writeLEB(module.getFunctionTable().size());
        for (WasmFunction function : module.getFunctionTable()) {
            section.writeLEB(this.functionIndexes.get(function.getName()));
        }
        this.writeSection(9, "element", section.getData());
    }

    private void renderCode(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        List functions = module.getFunctions().values().stream().filter(function -> function.getImportName() == null).collect(Collectors.toList());
        section.writeLEB(functions.size());
        for (WasmFunction function2 : functions) {
            byte[] body = this.renderFunction(function2);
            section.writeLEB(body.length);
            section.writeBytes(body);
        }
        this.writeSection(10, "code", section.getData());
    }

    private byte[] renderFunction(WasmFunction function) {
        WasmBinaryWriter code = new WasmBinaryWriter();
        List<WasmLocal> localVariables = function.getLocalVariables();
        if ((localVariables = localVariables.subList(function.getParameters().size(), localVariables.size())).isEmpty()) {
            code.writeLEB(0);
        } else {
            ArrayList<LocalEntry> localEntries = new ArrayList<LocalEntry>();
            LocalEntry currentEntry = new LocalEntry(localVariables.get(0).getType());
            for (int i = 1; i < localVariables.size(); ++i) {
                WasmType type = localVariables.get(i).getType();
                if (currentEntry.type == type) {
                    ++currentEntry.count;
                    continue;
                }
                localEntries.add(currentEntry);
                currentEntry = new LocalEntry(type);
            }
            localEntries.add(currentEntry);
            code.writeLEB(localEntries.size());
            for (LocalEntry entry : localEntries) {
                code.writeLEB(entry.count);
                code.writeType(entry.type, this.version);
            }
        }
        Map<String, Integer> importIndexes = this.functionIndexes;
        WasmBinaryRenderingVisitor visitor = new WasmBinaryRenderingVisitor(code, this.version, this.functionIndexes, importIndexes, this.signatureIndexes);
        for (WasmExpression part : function.getBody()) {
            part.acceptVisitor(visitor);
        }
        code.writeByte(11);
        return code.getData();
    }

    private void renderInitializer(WasmBinaryWriter output, int value) {
        output.writeByte(65);
        output.writeLEB(value);
        output.writeByte(11);
    }

    private void renderData(WasmModule module) {
        if (module.getSegments().isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(module.getSegments().size());
        for (WasmMemorySegment segment : module.getSegments()) {
            section.writeByte(0);
            this.renderInitializer(section, segment.getOffset());
            section.writeLEB(segment.getLength());
            int chunkSize = 65536;
            for (int i = 0; i < segment.getLength(); i += chunkSize) {
                int next = Math.min(i + chunkSize, segment.getLength());
                section.writeBytes(segment.getData(i, next - i));
            }
        }
        this.writeSection(11, "data", section.getData());
    }

    private void renderNames(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        WasmBinaryWriter functionsSubsection = new WasmBinaryWriter();
        Collection functions = module.getFunctions().values();
        functions = functions.stream().filter(f -> f.getImportName() != null).collect(Collectors.toList());
        functionsSubsection.writeLEB(functions.size());
        for (WasmFunction function : functions) {
            functionsSubsection.writeLEB(this.functionIndexes.get(function.getName()));
            functionsSubsection.writeAsciiString(function.getName());
        }
        byte[] payload = functionsSubsection.getData();
        section.writeLEB(1);
        section.writeLEB(payload.length);
        section.writeBytes(payload);
        this.writeSection(0, "name", section.getData());
    }

    private void registerSignature(WasmSignature signature) {
        this.signatureIndexes.computeIfAbsent(signature, key -> {
            int result = this.signatures.size();
            this.signatures.add((WasmSignature)key);
            return result;
        });
    }

    private void writeSection(int id, String name, byte[] data) {
        this.output.writeByte(id);
        int length = data.length;
        if (id == 0) {
            length += name.length() + 1;
        }
        this.output.writeLEB(length);
        if (id == 0) {
            this.output.writeAsciiString(name);
        }
        this.output.writeBytes(data);
    }

    static class LocalEntry {
        WasmType type;
        int count = 1;

        LocalEntry(WasmType type) {
            this.type = type;
        }
    }
}

