/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataArray;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.binary.DataStructure;
import org.teavm.backend.wasm.binary.DataType;
import org.teavm.backend.wasm.binary.DataValue;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.common.IntegerArray;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.interop.Address;
import org.teavm.interop.Function;
import org.teavm.interop.Structure;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.classes.VirtualTable;
import org.teavm.model.classes.VirtualTableEntry;
import org.teavm.model.classes.VirtualTableProvider;
import org.teavm.runtime.RuntimeClass;

public class WasmClassGenerator {
    private ClassReaderSource processedClassSource;
    private ClassReaderSource classSource;
    public final NameProvider names;
    private Map<ValueType, ClassBinaryData> binaryDataMap = new LinkedHashMap<ValueType, ClassBinaryData>();
    private BinaryWriter binaryWriter;
    private Map<MethodReference, Integer> functions = new HashMap<MethodReference, Integer>();
    private List<String> functionTable = new ArrayList<String>();
    private VirtualTableProvider vtableProvider;
    private TagRegistry tagRegistry;
    private WasmStringPool stringPool;
    private DataStructure objectStructure = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS);
    private DataStructure classStructure = new DataStructure(8, this.objectStructure, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS);
    private IntegerArray staticGcRoots = new IntegerArray(1);
    private int staticGcRootsAddress;
    private static final int CLASS_SIZE = 1;
    private static final int CLASS_FLAGS = 2;
    private static final int CLASS_TAG = 3;
    private static final int CLASS_CANARY = 4;
    private static final int CLASS_NAME = 5;
    private static final int CLASS_ITEM_TYPE = 6;
    private static final int CLASS_ARRAY_TYPE = 7;
    private static final int CLASS_IS_INSTANCE = 8;
    private static final int CLASS_INIT = 9;
    private static final int CLASS_PARENT = 10;
    private static final int CLASS_ENUM_VALUES = 13;
    private static final int CLASS_LAYOUT = 14;
    private static final int CLASS_SIMPLE_NAME = 15;

    public WasmClassGenerator(ClassReaderSource processedClassSource, ClassReaderSource classSource, VirtualTableProvider vtableProvider, TagRegistry tagRegistry, BinaryWriter binaryWriter, NameProvider names) {
        this.processedClassSource = processedClassSource;
        this.classSource = classSource;
        this.vtableProvider = vtableProvider;
        this.tagRegistry = tagRegistry;
        this.binaryWriter = binaryWriter;
        this.stringPool = new WasmStringPool(this, binaryWriter);
        this.names = names;
    }

    public WasmStringPool getStringPool() {
        return this.stringPool;
    }

    private void addClass(ValueType type) {
        if (this.binaryDataMap.containsKey(type)) {
            return;
        }
        ClassBinaryData binaryData = new ClassBinaryData();
        binaryData.type = type;
        this.binaryDataMap.put(type, binaryData);
        if (type instanceof ValueType.Primitive) {
            int size = 0;
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    size = 1;
                    break;
                }
                case SHORT: 
                case CHARACTER: {
                    size = 2;
                    break;
                }
                case INTEGER: 
                case FLOAT: {
                    size = 4;
                    break;
                }
                case LONG: 
                case DOUBLE: {
                    size = 8;
                }
            }
            binaryData.data = this.createPrimitiveClassData(size, type);
            binaryData.start = this.binaryWriter.append(binaryData.data);
        } else if (type == ValueType.VOID) {
            binaryData.data = this.createPrimitiveClassData(0, type);
            binaryData.start = this.binaryWriter.append(binaryData.data);
        } else if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            ClassReader cls = this.classSource.get(className);
            if (cls != null) {
                this.calculateLayout(cls, binaryData);
                if (binaryData.start >= 0) {
                    binaryData.start = this.binaryWriter.append(this.createStructure(binaryData));
                }
            }
        } else if (type instanceof ValueType.Array) {
            ValueType itemType = ((ValueType.Array)type).getItemType();
            this.addClass(itemType);
            ClassBinaryData itemBinaryData = this.binaryDataMap.get(itemType);
            VirtualTable vtable = this.vtableProvider.lookup("java.lang.Object");
            int vtableSize = vtable != null ? vtable.size() : 0;
            DataArray arrayType = new DataArray(DataPrimitives.INT, vtableSize);
            DataValue wrapper = new DataStructure(0, this.classStructure, arrayType).createValue();
            if (vtableSize > 0) {
                this.fillVirtualTable(vtable, wrapper.getValue(1));
            }
            binaryData.size = 4;
            binaryData.data = wrapper.getValue(0);
            binaryData.data.setInt(1, 4);
            binaryData.data.setAddress(6, itemBinaryData.start);
            binaryData.data.setInt(8, this.functionTable.size());
            binaryData.data.setInt(4, RuntimeClass.computeCanary(4, 0));
            this.functionTable.add(this.names.forSupertypeFunction(type));
            binaryData.data.setAddress(5, this.stringPool.getStringPointer(type.toString().replace('/', '.')));
            binaryData.data.setAddress(15, 0L);
            binaryData.data.setInt(9, -1);
            binaryData.data.setAddress(10, this.getClassPointer(ValueType.object("java.lang.Object")));
            binaryData.start = this.binaryWriter.append(vtableSize > 0 ? wrapper : binaryData.data);
            itemBinaryData.data.setAddress(7, binaryData.start);
        }
    }

    private DataValue createPrimitiveClassData(int size, ValueType type) {
        String name;
        DataValue value = this.classStructure.createValue();
        value.setInt(1, size);
        value.setInt(2, 2);
        value.setInt(8, this.functionTable.size());
        value.setAddress(15, 0L);
        value.setInt(9, -1);
        this.functionTable.add(this.names.forSupertypeFunction(type));
        if (type == ValueType.VOID) {
            name = "void";
        } else {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    name = "boolean";
                    break;
                }
                case BYTE: {
                    name = "byte";
                    break;
                }
                case SHORT: {
                    name = "short";
                    break;
                }
                case CHARACTER: {
                    name = "char";
                    break;
                }
                case INTEGER: {
                    name = "int";
                    break;
                }
                case LONG: {
                    name = "long";
                    break;
                }
                case FLOAT: {
                    name = "float";
                    break;
                }
                case DOUBLE: {
                    name = "double";
                    break;
                }
                default: {
                    name = "";
                }
            }
        }
        value.setAddress(5, this.stringPool.getStringPointer(name));
        return value;
    }

    public List<String> getFunctionTable() {
        return this.functionTable;
    }

    private DataValue createStructure(ClassBinaryData binaryData) {
        List<FieldReference> fields;
        DataValue header;
        String parent = binaryData.cls.getParent();
        int parentPtr = !binaryData.isInferface && parent != null ? this.getClassPointer(ValueType.object(binaryData.cls.getParent())) : 0;
        String name = ((ValueType.Object)binaryData.type).getClassName();
        int flags = 0;
        VirtualTable vtable = this.vtableProvider.lookup(name);
        int vtableSize = vtable != null ? vtable.size() : 0;
        DataArray arrayType = new DataArray(DataPrimitives.INT, vtableSize);
        DataValue wrapper = new DataStructure(0, this.classStructure, arrayType).createValue();
        DataValue array = wrapper.getValue(1);
        binaryData.data = header = wrapper.getValue(0);
        int occupiedSize = binaryData.size;
        if ((occupiedSize & 3) != 0) {
            occupiedSize = occupiedSize >> 2 << 3;
        }
        header.setInt(1, occupiedSize);
        List<TagRegistry.Range> ranges = this.tagRegistry.getRanges(name);
        int tag = ranges.stream().mapToInt(range -> range.lower).min().orElse(0);
        header.setInt(3, tag);
        header.setInt(4, RuntimeClass.computeCanary(occupiedSize, tag));
        header.setAddress(5, this.stringPool.getStringPointer(name));
        header.setInt(8, this.functionTable.size());
        this.functionTable.add(this.names.forSupertypeFunction(ValueType.object(name)));
        header.setAddress(10, parentPtr);
        if (vtable != null) {
            this.fillVirtualTable(vtable, array);
        }
        if (!(fields = this.getReferenceFields(binaryData.cls)).isEmpty()) {
            DataValue layoutSize = DataPrimitives.SHORT.createValue();
            layoutSize.setShort(0, (short)fields.size());
            header.setAddress(14, this.binaryWriter.append(layoutSize));
            for (FieldReference field : fields) {
                DataValue layoutElement = DataPrimitives.SHORT.createValue();
                int offset = binaryData.fieldLayout.get(field.getFieldName());
                layoutElement.setShort(0, (short)offset);
                this.binaryWriter.append(layoutElement);
            }
        }
        for (FieldReference field : this.getStaticReferenceFields(binaryData.cls)) {
            this.staticGcRoots.add(binaryData.fieldLayout.get(field.getFieldName()));
        }
        ClassReader cls = this.processedClassSource.get(name);
        if (cls != null && cls.hasModifier(ElementModifier.ENUM)) {
            header.setAddress(13, this.generateEnumValues(cls, binaryData));
            flags |= 4;
        }
        if (cls != null && binaryData.start >= 0 && cls.getMethod(new MethodDescriptor("<clinit>", ValueType.VOID)) != null) {
            header.setInt(9, this.functionTable.size());
            this.functionTable.add(this.names.forClassInitializer(name));
        } else {
            header.setInt(9, -1);
        }
        header.setInt(2, flags);
        header.setAddress(15, 0L);
        return vtable != null ? wrapper : header;
    }

    private int generateEnumValues(ClassReader cls, ClassBinaryData binaryData) {
        FieldReader[] fields = (FieldReader[])cls.getFields().stream().filter(field -> field.hasModifier(ElementModifier.ENUM)).toArray(FieldReader[]::new);
        DataValue sizeValue = DataPrimitives.ADDRESS.createValue();
        sizeValue.setAddress(0, fields.length);
        int valuesAddress = this.binaryWriter.append(sizeValue);
        for (FieldReader field2 : fields) {
            DataValue fieldRefValue = DataPrimitives.ADDRESS.createValue();
            fieldRefValue.setAddress(0, binaryData.fieldLayout.get(field2.getName()));
            this.binaryWriter.append(fieldRefValue);
        }
        return valuesAddress;
    }

    private List<FieldReference> getReferenceFields(ClassReader cls) {
        return cls.getFields().stream().filter(field -> !field.hasModifier(ElementModifier.STATIC)).filter(field -> this.isReferenceType(field.getType())).filter(field -> !field.getOwnerName().equals("java.lang.Object") && !field.getName().equals("monitor")).map(field -> field.getReference()).collect(Collectors.toList());
    }

    private List<FieldReference> getStaticReferenceFields(ClassReader cls) {
        return cls.getFields().stream().filter(field -> field.hasModifier(ElementModifier.STATIC)).filter(field -> this.isReferenceType(field.getType())).map(field -> field.getReference()).collect(Collectors.toList());
    }

    private boolean isReferenceType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            return false;
        }
        if (type instanceof ValueType.Object) {
            ClassReader cls = this.classSource.get(((ValueType.Object)type).getClassName());
            if (cls == null) {
                return true;
            }
            if (cls.getName().equals(Address.class.getName())) {
                return false;
            }
            while (cls != null) {
                if (cls.getName().equals(Structure.class.getName()) || cls.getName().equals(Function.class.getName())) {
                    return false;
                }
                if (cls.getParent() == null) {
                    return true;
                }
                cls = this.classSource.get(cls.getParent());
            }
            return true;
        }
        return true;
    }

    private void fillVirtualTable(VirtualTable vtable, DataValue array) {
        int index = 0;
        ArrayList<VirtualTable> tables = new ArrayList<VirtualTable>();
        for (VirtualTable vt = vtable; vt != null; vt = vt.getParent()) {
            tables.add(vt);
        }
        for (int i = tables.size() - 1; i >= 0; --i) {
            for (MethodDescriptor methodDescriptor : ((VirtualTable)tables.get(i)).getMethods()) {
                VirtualTableEntry entry;
                int methodIndex = -1;
                if (methodDescriptor != null && (entry = vtable.getEntry(methodDescriptor)) != null) {
                    methodIndex = this.functions.computeIfAbsent(entry.getImplementor(), implementor -> {
                        int result = this.functionTable.size();
                        this.functionTable.add(this.names.forMethod((MethodReference)implementor));
                        return result;
                    });
                }
                array.setInt(index++, methodIndex);
            }
        }
    }

    public Collection<ValueType> getRegisteredClasses() {
        return this.binaryDataMap.keySet();
    }

    public int getClassPointer(ValueType type) {
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        return data.start;
    }

    public int getFieldOffset(FieldReference field) {
        ValueType type = ValueType.object(field.getClassName());
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        return data.fieldLayout.get(field.getFieldName());
    }

    public int getClassSize(String className) {
        ValueType type = ValueType.object(className);
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        return data.size;
    }

    public int getClassAlignment(String className) {
        ValueType type = ValueType.object(className);
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        return data.alignment;
    }

    public boolean isStructure(String className) {
        ValueType type = ValueType.object(className);
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        return data.start < 0;
    }

    public boolean isFunctionClass(String className) {
        ValueType type = ValueType.object(className);
        this.addClass(type);
        return this.binaryDataMap.get((Object)type).function;
    }

    private void calculateLayout(ClassReader cls, ClassBinaryData data) {
        if (cls.getName().equals(Structure.class.getName()) || cls.getName().equals(Address.class.getName())) {
            data.size = 0;
            data.start = -1;
            return;
        }
        if (cls.getName().equals(Function.class.getName())) {
            data.size = 0;
            data.start = -1;
            data.function = true;
            return;
        }
        if (cls.getParent() != null) {
            this.addClass(ValueType.object(cls.getParent()));
            ClassBinaryData parentData = this.binaryDataMap.get(ValueType.object(cls.getParent()));
            data.size = parentData.size;
            data.alignment = parentData.alignment;
            if (parentData.start == -1) {
                data.start = -1;
            }
            if (parentData.function) {
                data.function = true;
                return;
            }
        } else {
            data.size = 4;
            data.alignment = 4;
        }
        data.isInferface = cls.hasModifier(ElementModifier.INTERFACE);
        data.cls = cls;
        for (FieldReader fieldReader : cls.getFields()) {
            int desiredAlignment = WasmClassGenerator.getTypeSize(fieldReader.getType());
            if (fieldReader.hasModifier(ElementModifier.STATIC)) {
                DataType type = WasmClassGenerator.asDataType(fieldReader.getType());
                DataValue value = type.createValue();
                if (fieldReader.getInitialValue() != null) {
                    this.setInitialValue(fieldReader.getType(), value, fieldReader.getInitialValue());
                }
                data.fieldLayout.put(fieldReader.getName(), this.binaryWriter.append(value));
            } else {
                int offset = WasmClassGenerator.align(data.size, desiredAlignment);
                data.fieldLayout.put(fieldReader.getName(), offset);
                data.size = offset + desiredAlignment;
            }
            if (data.alignment != 0) continue;
            data.alignment = desiredAlignment;
        }
    }

    private void setInitialValue(ValueType type, DataValue data, Object value) {
        if (value instanceof Number) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BYTE: {
                    data.setByte(0, ((Number)value).byteValue());
                    break;
                }
                case SHORT: {
                    data.setShort(0, ((Number)value).shortValue());
                    break;
                }
                case CHARACTER: {
                    data.setShort(0, ((Number)value).shortValue());
                    break;
                }
                case INTEGER: {
                    data.setInt(0, ((Number)value).intValue());
                    break;
                }
                case LONG: {
                    data.setLong(0, ((Number)value).longValue());
                    break;
                }
                case FLOAT: {
                    data.setFloat(0, ((Number)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    data.setDouble(0, ((Number)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    data.setByte(0, ((Number)value).byteValue());
                }
            }
        } else if (value instanceof Boolean) {
            data.setByte(0, (Boolean)value != false ? (byte)1 : 0);
        } else if (value instanceof String) {
            data.setAddress(0, this.stringPool.getStringPointer((String)value));
        }
    }

    private static DataType asDataType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return DataPrimitives.BYTE;
                }
                case SHORT: 
                case CHARACTER: {
                    return DataPrimitives.SHORT;
                }
                case INTEGER: {
                    return DataPrimitives.INT;
                }
                case LONG: {
                    return DataPrimitives.LONG;
                }
                case FLOAT: {
                    return DataPrimitives.FLOAT;
                }
                case DOUBLE: {
                    return DataPrimitives.DOUBLE;
                }
            }
        }
        return DataPrimitives.ADDRESS;
    }

    public static int align(int base, int alignment) {
        if (base == 0) {
            return 0;
        }
        return ((base - 1) / alignment + 1) * alignment;
    }

    public static int getTypeSize(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return 1;
                }
                case SHORT: 
                case CHARACTER: {
                    return 2;
                }
                case INTEGER: 
                case FLOAT: {
                    return 4;
                }
                case LONG: 
                case DOUBLE: {
                    return 8;
                }
            }
        }
        return 4;
    }

    public void postProcess() {
        ClassBinaryData classClassData = this.binaryDataMap.get(ValueType.object("java.lang.Class"));
        if (classClassData != null) {
            int tag = classClassData.start >> 3 | Integer.MIN_VALUE;
            for (ClassBinaryData classData : this.binaryDataMap.values()) {
                if (classData.data == null) continue;
                classData.data.getValue(0).setInt(0, tag);
            }
        }
        this.writeStaticGcRoots();
    }

    public int getStaticGcRootsAddress() {
        return this.staticGcRootsAddress;
    }

    private void writeStaticGcRoots() {
        DataValue sizeValue = DataPrimitives.LONG.createValue();
        sizeValue.setLong(0, this.staticGcRoots.size());
        this.staticGcRootsAddress = this.binaryWriter.append(sizeValue);
        for (int gcRoot : this.staticGcRoots.getAll()) {
            DataValue value = DataPrimitives.ADDRESS.createValue();
            value.setAddress(0, gcRoot);
            this.binaryWriter.append(value);
        }
    }

    public boolean hasClinit(String className) {
        if (this.isStructure(className) || className.equals(Address.class.getName())) {
            return false;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return false;
        }
        return cls.getMethod(new MethodDescriptor("<clinit>", ValueType.VOID)) != null;
    }

    private class ClassBinaryData {
        ValueType type;
        int size;
        int alignment;
        int start;
        boolean isInferface;
        ObjectIntMap<String> fieldLayout = new ObjectIntHashMap<String>();
        DataValue data;
        ClassReader cls;
        boolean function;

        private ClassBinaryData() {
        }
    }
}

