/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

@ManagedObject(value="Dumpable Object")
public interface Dumpable {
    public static final String KEY = "key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined";

    @ManagedOperation(value="Dump the nested Object state as a String", impact="INFO")
    default public String dump() {
        return Dumpable.dump(this);
    }

    public void dump(Appendable var1, String var2) throws IOException;

    public static String dump(Dumpable dumpable) {
        StringBuilder b = new StringBuilder();
        try {
            dumpable.dump(b, "");
        }
        catch (IOException e) {
            b.append(e.toString());
        }
        b.append(KEY);
        return b.toString();
    }

    public static void dumpObject(Appendable out, Object o) throws IOException {
        try {
            String s = o == null ? "null" : (o instanceof Collection ? String.format("%s@%x(size=%d)", o.getClass().getName(), o.hashCode(), ((Collection)o).size()) : (o.getClass().isArray() ? String.format("%s@%x[size=%d]", o.getClass().getComponentType(), o.hashCode(), Array.getLength(o)) : (o instanceof Map ? String.format("%s@%x{size=%d}", o.getClass().getName(), o.hashCode(), ((Map)o).size()) : String.valueOf(o).replace("\r\n", "|").replace("\n", "|"))));
            if (o instanceof LifeCycle) {
                out.append(s).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)o)).append("\n");
            } else {
                out.append(s).append("\n");
            }
        }
        catch (Throwable th) {
            out.append("=>").append(th.toString()).append("\n");
        }
    }

    public static void dumpObjects(Appendable out, String indent, Object object, Object ... extraChildren) throws IOException {
        String nextIndent;
        Iterator<Object> i;
        int size;
        Dumpable.dumpObject(out, object);
        int n = size = extraChildren == null ? 0 : extraChildren.length;
        if (object instanceof Stream) {
            object = ((Stream)object).toArray();
        }
        if (object instanceof Array) {
            object = Arrays.asList(object);
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            ContainerLifeCycle containerLifeCycle = container instanceof ContainerLifeCycle ? (ContainerLifeCycle)container : null;
            Iterator<Object> i2 = container.getBeans().iterator();
            while (i2.hasNext()) {
                Object bean = i2.next();
                String nextIndent2 = indent + (i2.hasNext() || size > 0 ? "| " : "  ");
                if (bean instanceof LifeCycle) {
                    if (container.isManaged(bean)) {
                        out.append(indent).append("+=");
                        if (bean instanceof Dumpable) {
                            ((Dumpable)bean).dump(out, nextIndent2);
                            continue;
                        }
                        Dumpable.dumpObjects(out, nextIndent2, bean, new Object[0]);
                        continue;
                    }
                    if (containerLifeCycle != null && containerLifeCycle.isAuto(bean)) {
                        out.append(indent).append("+?");
                        if (bean instanceof Dumpable) {
                            ((Dumpable)bean).dump(out, nextIndent2);
                            continue;
                        }
                        Dumpable.dumpObjects(out, nextIndent2, bean, new Object[0]);
                        continue;
                    }
                    out.append(indent).append("+~");
                    Dumpable.dumpObject(out, bean);
                    continue;
                }
                if (containerLifeCycle != null && containerLifeCycle.isUnmanaged(bean)) {
                    out.append(indent).append("+~");
                    Dumpable.dumpObject(out, bean);
                    continue;
                }
                out.append(indent).append("+-");
                if (bean instanceof Dumpable) {
                    ((Dumpable)bean).dump(out, nextIndent2);
                    continue;
                }
                Dumpable.dumpObjects(out, nextIndent2, bean, new Object[0]);
            }
        }
        if (object instanceof Iterable) {
            i = ((Iterable)object).iterator();
            while (i.hasNext()) {
                Object item = i.next();
                nextIndent = indent + (i.hasNext() || size > 0 ? "| " : "  ");
                out.append(indent).append("+:");
                if (item instanceof Dumpable) {
                    ((Dumpable)item).dump(out, nextIndent);
                    continue;
                }
                Dumpable.dumpObjects(out, nextIndent, item, new Object[0]);
            }
        } else if (object instanceof Map) {
            i = ((Map)object).entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                nextIndent = indent + (i.hasNext() || size > 0 ? "| " : "  ");
                out.append(indent).append("+@").append(String.valueOf(entry.getKey())).append('=');
                Object item = entry.getValue();
                if (item instanceof Dumpable) {
                    ((Dumpable)item).dump(out, nextIndent);
                    continue;
                }
                Dumpable.dumpObjects(out, nextIndent, item, new Object[0]);
            }
        }
        if (size == 0) {
            return;
        }
        int i3 = 0;
        for (Object item : extraChildren) {
            String nextIndent3 = indent + (++i3 < size ? "| " : "  ");
            out.append(indent).append("+>");
            if (item instanceof Dumpable) {
                ((Dumpable)item).dump(out, nextIndent3);
                continue;
            }
            Dumpable.dumpObjects(out, nextIndent3, item, new Object[0]);
        }
    }
}

