/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import org.teavm.apachecommons.cli.CommandLine;
import org.teavm.apachecommons.cli.DefaultParser;
import org.teavm.apachecommons.cli.HelpFormatter;
import org.teavm.apachecommons.cli.Option;
import org.teavm.apachecommons.cli.Options;
import org.teavm.apachecommons.cli.ParseException;
import org.teavm.tooling.ConsoleTeaVMToolLog;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.c.incremental.IncrementalCBuilder;

public class TeaVMCBuilderRunner {
    private static Options options = new Options();
    private IncrementalCBuilder builder;
    private CommandLine commandLine;

    private static void setupOptions() {
        options.addOption(Option.builder((String)"d").argName("directory").hasArg().desc("a directory in which generated C files will be placed").longOpt("targetdir").build());
        options.addOption(Option.builder((String)"p").argName("classpath").hasArgs().desc("classpath element (either directory or jar file)").longOpt("classpath").build());
        options.addOption(Option.builder((String)"v").desc("display more messages on server log").longOpt("verbose").build());
        options.addOption(Option.builder((String)"g").desc("generate debugger-friendly code").longOpt("debug").build());
        options.addOption(Option.builder().longOpt("min-heap").argName("size").hasArg().desc("Minimum heap size in megabytes").build());
        options.addOption(Option.builder().longOpt("max-heap").argName("size").hasArg().desc("Minimum heap size in megabytes").build());
        options.addOption(Option.builder((String)"e").longOpt("entry-point").argName("name").hasArg().desc("Name of entry point function (main by default)").build());
        options.addOption(Option.builder().longOpt("external-tool").argName("path").hasArg().desc("Process to run after successful build").build());
        options.addOption(Option.builder().longOpt("external-tool-workdir").argName("path").hasArg().desc("Working directory of process").build());
    }

    private TeaVMCBuilderRunner(CommandLine commandLine) {
        this.commandLine = commandLine;
        this.builder = new IncrementalCBuilder();
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        if (args.length == 0) {
            TeaVMCBuilderRunner.printUsage();
            return;
        }
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMCBuilderRunner.printUsage();
            return;
        }
        TeaVMCBuilderRunner runner = new TeaVMCBuilderRunner(commandLine);
        runner.parseArguments();
        runner.runAll();
    }

    private void parseArguments() {
        String[] args;
        this.parseClassPathOptions();
        this.parseOutputOptions();
        this.parseHeap();
        this.parseExternalTool();
        this.builder.setLog((TeaVMToolLog)new ConsoleTeaVMToolLog(this.commandLine.hasOption('v')));
        this.builder.setLineNumbersGenerated(this.commandLine.hasOption('g'));
        if (this.commandLine.hasOption('e')) {
            this.builder.setMainFunctionName(this.commandLine.getOptionValue('e'));
        }
        if ((args = this.commandLine.getArgs()).length != 1) {
            System.err.println("Unexpected arguments");
            TeaVMCBuilderRunner.printUsage();
        } else {
            this.builder.setMainClass(args[0]);
        }
    }

    private void parseExternalTool() {
        boolean hasExternalTool = false;
        if (this.commandLine.hasOption("external-tool")) {
            this.builder.setExternalTool(this.commandLine.getOptionValue("external-tool"));
            hasExternalTool = true;
        }
        if (this.commandLine.hasOption("external-tool-workdir")) {
            if (!hasExternalTool) {
                System.err.println("Redundant 'external-tool-workdir' option: no external tool specified");
            } else {
                this.builder.setExternalToolWorkingDir(this.commandLine.getOptionValue("external-tool-workdir"));
            }
        }
    }

    private void parseOutputOptions() {
        if (this.commandLine.hasOption("d")) {
            this.builder.setTargetPath(this.commandLine.getOptionValue("d"));
        }
    }

    private void parseClassPathOptions() {
        if (this.commandLine.hasOption('p')) {
            this.builder.setClassPath(this.commandLine.getOptionValues('p'));
        }
    }

    private void parseHeap() {
        int size;
        if (this.commandLine.hasOption("min-heap")) {
            try {
                size = Integer.parseInt(this.commandLine.getOptionValue("min-heap"));
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong heap size");
                TeaVMCBuilderRunner.printUsage();
                return;
            }
            this.builder.setMinHeapSize(size);
        }
        if (this.commandLine.hasOption("max-heap")) {
            try {
                size = Integer.parseInt(this.commandLine.getOptionValue("max-heap"));
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong heap size");
                TeaVMCBuilderRunner.printUsage();
                return;
            }
            this.builder.setMaxHeapSize(size);
        }
    }

    private void runAll() {
        this.builder.start();
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMCBuilderRunner.class.getName() + " [OPTIONS] [qualified.main.Class]", options);
        System.exit(-1);
    }

    static {
        TeaVMCBuilderRunner.setupOptions();
    }
}

